package adfactory.player.android.Video;

import adfactory.player.android.Models.VideoModel;

/**
 * Created by medyo on 3/14/18.
 */

public interface VideoInteractor {

    interface Presenter {

        void onCreate(String embed);

        void checkVideo(String embed);

        void playAlternativePlayer(String embed);

        void findVideoData(String videoId);

        void autoOrientation();
    }

    interface View {

        boolean isConfigured();

        void resume();

        void pause();

        boolean isLandscape();

        void displayLandscapeMode();

        void displayPortraitMode();

        String getEmbed();

        boolean isAnAdfactoryUrl(String embed);

        void displayError(Exception exception);

        void hideError();

        String getVideoId(String embed);

        String getVideoUrl(String embed);

        void playAlternativePlayer(String embed);

        void loadVideo(VideoModel video);

        void pauseVideo();
    }

    interface VideoCommunicator {
        void onError(Exception e);
    }

    interface onVideoReady{
        void onReady(VideoModel video);

        void onFailure(Exception e);
    }

    interface Data {
        void findVideoById(String videoId, onVideoReady callback);
    }
}
