/*
 * Decompiled with CFR 0.152.
 */
package adfactory.player.android.Video;

import adfactory.player.android.Models.VideoModel;
import adfactory.player.android.R;
import adfactory.player.android.Utils.Html5WebVideoView;
import adfactory.player.android.Utils.Utils;
import adfactory.player.android.Video.VideoInteractor;
import adfactory.player.android.Video.VideoPresenter;
import adfactory.player.android.Video.data.VideoDataRepository;
import adfactory.player.android.interfaces.onVideoReady;
import android.content.Context;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.support.v4.widget.ContentLoadingProgressBar;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.view.Window;
import android.webkit.URLUtil;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.android.exoplayer2.DefaultLoadControl;
import com.google.android.exoplayer2.DefaultRenderersFactory;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.ExoPlayerFactory;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.RenderersFactory;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.ext.ima.ImaAdsLoader;
import com.google.android.exoplayer2.source.ExtractorMediaSource;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.source.ads.AdsLoader;
import com.google.android.exoplayer2.source.ads.AdsMediaSource;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.ui.PlayerView;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultHttpDataSourceFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VideoView
extends RelativeLayout
implements VideoInteractor.VideoCommunicator,
VideoInteractor.View {
    VideoPresenter mPresenter;
    RelativeLayout mWrapper;
    TextView mTextError;
    int mVideoViewBackgroundColor;
    onVideoReady mCallback;
    Boolean mSetupReady = false;
    Html5WebVideoView mWebView;
    int mSeekBarColor;
    String mEmbed;
    View mView;
    PlayerView mExoPlayerView;
    ExoPlayer mExoPlayerFactory;
    ContentLoadingProgressBar mProgressBar;
    long mLastPosition = 0L;
    View mFullScreenButton;

    private void initFullscreenButton() {
        this.mFullScreenButton = this.mView.findViewById(R.id.exo_fullscreen_icon);
        this.mFullScreenButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (!VideoView.this.isLandscape()) {
                    VideoView.this.displayLandscapeMode();
                } else {
                    VideoView.this.displayPortraitMode();
                }
            }
        });
    }

    public VideoView(Context context) {
        super(context);
        this.setupView();
    }

    public VideoView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setupView();
    }

    private void setupView() {
        this.mView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.adfactory_player, (ViewGroup)this);
        this.mVideoViewBackgroundColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.adfactory_default_background_color);
        this.mSeekBarColor = Utils.getThemeAccentColor(this.getContext());
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mWrapper = (RelativeLayout)this.mView.findViewById(R.id.wrapper);
        this.mTextError = (TextView)this.mView.findViewById(R.id.error_text_view);
        this.mWebView = (Html5WebVideoView)this.mView.findViewById(R.id.adfactory_webView);
        this.mWrapper.setBackgroundColor(this.mVideoViewBackgroundColor);
    }

    public void setPayload(String string2) {
        this.mEmbed = string2;
        this.mExoPlayerFactory = ExoPlayerFactory.newSimpleInstance((RenderersFactory)new DefaultRenderersFactory(this.getContext()), (TrackSelector)new DefaultTrackSelector(), (LoadControl)new DefaultLoadControl());
        this.mExoPlayerFactory.setPlayWhenReady(true);
        this.mExoPlayerFactory.seekTo(0, 0L);
        this.mPresenter = new VideoPresenter(this, new VideoDataRepository(Utils.getApiKey(this.getContext())));
        this.mPresenter.onCreate(this.mEmbed);
    }

    @Override
    public boolean isConfigured() {
        this.mSetupReady = !TextUtils.isEmpty((CharSequence)Utils.getApiKey(this.getContext()));
        if (!this.mSetupReady.booleanValue()) {
            Log.e((String)"AdFactory", (String)"Please add <meta-data android:name=\"com.adfactory.key\"\n            android:value=\"Your Api Key\" /> To your manifest file");
        }
        return this.mSetupReady;
    }

    @Override
    public boolean isLandscape() {
        int n = this.getResources().getConfiguration().orientation;
        return n == 2 || this.mFullScreenButton.getTag() != null && this.mFullScreenButton.getTag().equals("landscape");
    }

    @Override
    public void displayLandscapeMode() {
        this.mFullScreenButton.setTag((Object)"landscape");
        this.getWindow().setFlags(1024, 1024);
        this.getWindow().clearFlags(2048);
        ViewGroup.LayoutParams layoutParams = this.mWrapper.getLayoutParams();
        layoutParams.width = -1;
        layoutParams.height = -1;
        this.mWrapper.setLayoutParams(layoutParams);
        if (this.mCallback != null) {
            this.mCallback.onOrientationChange(true);
        }
        this.getWindow().getDecorView().requestLayout();
    }

    private Window getWindow() {
        return ((AppCompatActivity)this.getContext()).getWindow();
    }

    @Override
    public void displayPortraitMode() {
        this.mFullScreenButton.setTag((Object)"portrait");
        int n = this.getResources().getDimensionPixelSize(R.dimen.adfactory_video_height);
        this.getWindow().clearFlags(1024);
        this.getWindow().addFlags(2048);
        ViewGroup.LayoutParams layoutParams = this.mWrapper.getLayoutParams();
        layoutParams.width = -1;
        layoutParams.height = n;
        this.mWrapper.setLayoutParams(layoutParams);
        if (this.mCallback != null) {
            this.mCallback.onOrientationChange(false);
        }
        this.getWindow().getDecorView().requestLayout();
    }

    @Override
    public String getEmbed() {
        return this.mEmbed;
    }

    @Override
    public boolean isAnAdfactoryUrl(String string2) {
        if (URLUtil.isHttpUrl((String)string2) || URLUtil.isHttpsUrl((String)string2)) {
            String string3 = Utils.getDomainName(string2);
            return Arrays.asList("cdnvideo", "adfactory").contains(string3);
        }
        return false;
    }

    @Override
    public void displayError(Exception exception) {
        if (exception.getMessage().equalsIgnoreCase("key")) {
            this.mTextError.setText((CharSequence)this.getResources().getString(R.string.adfactory_exception_missing_key));
        } else if (exception.getMessage().equalsIgnoreCase("not_found")) {
            this.mTextError.setText((CharSequence)this.getResources().getString(R.string.adfactory_exception_video_not_found));
        } else {
            this.mTextError.setText((CharSequence)"Unknown Error");
        }
        this.mTextError.setVisibility(0);
    }

    @Override
    public void hideError() {
        this.mTextError.setVisibility(8);
    }

    @Override
    public String getVideoId(String string2) {
        return Utils.extractVideoId(string2);
    }

    @Override
    public String getVideoUrl(String string2) {
        return Utils.extractVideoUrl(string2);
    }

    @Override
    public void playAlternativePlayer(String string2) {
        ViewStub viewStub = (ViewStub)this.mView.findViewById(R.id.stub_video_web_view);
        viewStub.inflate();
        this.mWebView = (Html5WebVideoView)this.mView.findViewById(R.id.adfactory_webView);
        this.mWebView.setAutoPlay(true);
        string2 = string2.replace("https", "http");
        Pattern pattern = Pattern.compile("(?:width|height)=(?:(['\"\"])(.*?)\\1|.*)");
        Matcher matcher = pattern.matcher(string2);
        StringBuffer stringBuffer = new StringBuffer(string2.length());
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, matcher.group(0).replaceAll("=(?:(['\"\"])(.*?)\\1|.*)", "=\"100%\""));
        }
        matcher.appendTail(stringBuffer);
        String string3 = "<html><body style='margin:0;padding:0;height:100%;width:100%'>" + stringBuffer + "</body><html>";
        this.mWebView.loadData(string3, "text/html", "UTF-8");
    }

    protected void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.mPresenter.autoOrientation();
    }

    @Override
    public void loadVideo(VideoModel videoModel) {
        ViewStub viewStub = (ViewStub)this.mView.findViewById(R.id.stub_video_player);
        viewStub.inflate();
        this.mExoPlayerView = (PlayerView)this.mView.findViewById(R.id.adfactory_video_view2);
        this.mExoPlayerView.setPlayer((Player)this.mExoPlayerFactory);
        this.mProgressBar = (ContentLoadingProgressBar)this.findViewById(R.id.adfactory_progress_bar);
        this.mExoPlayerFactory.addListener(new Player.EventListener(){

            public void onTimelineChanged(Timeline timeline, Object object, int n) {
            }

            public void onTracksChanged(TrackGroupArray trackGroupArray, TrackSelectionArray trackSelectionArray) {
            }

            public void onLoadingChanged(boolean bl) {
            }

            public void onPlayerStateChanged(boolean bl, int n) {
                if (n == 2) {
                    VideoView.this.mProgressBar.show();
                    VideoView.this.mExoPlayerView.findViewById(R.id.exo_play).setVisibility(8);
                    VideoView.this.mExoPlayerView.findViewById(R.id.exo_pause).setVisibility(8);
                } else {
                    VideoView.this.mProgressBar.hide();
                    if (VideoView.this.mExoPlayerView.getPlayer().getPlayWhenReady()) {
                        VideoView.this.mExoPlayerView.hideController();
                    } else {
                        VideoView.this.mExoPlayerView.showController();
                    }
                }
            }

            public void onRepeatModeChanged(int n) {
            }

            public void onShuffleModeEnabledChanged(boolean bl) {
            }

            public void onPlayerError(ExoPlaybackException exoPlaybackException) {
            }

            public void onPositionDiscontinuity(int n) {
            }

            public void onPlaybackParametersChanged(PlaybackParameters playbackParameters) {
            }

            public void onSeekProcessed() {
            }
        });
        String string2 = this.getResources().getString(R.string.adfactory_sample_video_url);
        String string3 = this.getResources().getString(R.string.adfactory_sample_ad_tag_url);
        string3 = videoModel.getDfp();
        ImaAdsLoader imaAdsLoader = new ImaAdsLoader(this.getContext(), Uri.parse((String)string3));
        DefaultHttpDataSourceFactory defaultHttpDataSourceFactory = new DefaultHttpDataSourceFactory("elbotola-app");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Referer", string2);
        hashMap.put("app-source", "adfactory.player.android");
        defaultHttpDataSourceFactory.getDefaultRequestProperties().set(hashMap);
        ExtractorMediaSource extractorMediaSource = new ExtractorMediaSource.Factory((DataSource.Factory)defaultHttpDataSourceFactory).createMediaSource(Uri.parse((String)string2));
        AdsMediaSource adsMediaSource = new AdsMediaSource((MediaSource)extractorMediaSource, (DataSource.Factory)defaultHttpDataSourceFactory, (AdsLoader)imaAdsLoader, (ViewGroup)this.mExoPlayerView.getOverlayFrameLayout());
        this.mExoPlayerFactory.prepare((MediaSource)adsMediaSource, true, false);
        this.initFullscreenButton();
    }

    @Override
    public void pauseVideo() {
    }

    @Override
    public void resume() {
        if (this.mExoPlayerView != null) {
            this.mExoPlayerView.getPlayer().seekTo(this.mLastPosition);
            this.mExoPlayerView.getPlayer().setPlayWhenReady(true);
            this.mExoPlayerView.getPlayer().getPlaybackState();
        }
    }

    @Override
    public void pause() {
        if (this.mExoPlayerView != null) {
            this.mLastPosition = this.mExoPlayerView.getPlayer().getCurrentPosition();
            this.mExoPlayerView.getPlayer().setPlayWhenReady(false);
            this.mExoPlayerView.getPlayer().getPlaybackState();
        }
        if (this.mWebView != null) {
            try {
                Class.forName("android.webkit.WebView").getMethod("onPause", null).invoke((Object)this.mWebView, (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (Build.VERSION.SDK_INT >= 11) {
                this.mWebView.onPause();
            }
            this.mWebView.stopLoading();
            this.mWebView.loadUrl("about:blank");
            this.mWebView.reload();
            this.mWebView = null;
        }
    }

    @Override
    public void onError(Exception exception) {
        if (this.mPresenter != null) {
            this.mPresenter.onFailure(exception);
        }
    }
}

