/*
 * Decompiled with CFR 0.152.
 */
package adfactory.player.android.Video;

import adfactory.player.android.Models.VideoModel;
import adfactory.player.android.Video.VideoInteractor;
import adfactory.player.android.Video.data.VideoDataRepository;

public class VideoPresenter
implements VideoInteractor.Presenter,
VideoInteractor.onVideoReady {
    VideoInteractor.View mView;
    VideoDataRepository mData;

    public VideoPresenter(VideoInteractor.View view, VideoDataRepository videoDataRepository) {
        this.mView = view;
        this.mData = videoDataRepository;
    }

    @Override
    public void onCreate(String string) {
        if (!this.mView.isConfigured()) {
            this.mView.displayError(new Exception("key"));
        } else {
            this.mView.hideError();
            this.checkVideo(string);
        }
    }

    @Override
    public void checkVideo(String string) {
        if (this.mView.isAnAdfactoryUrl(string)) {
            String string2 = this.mView.getVideoId(string);
            this.findVideoData(string2);
        } else if (!this.mView.getVideoUrl(string).isEmpty()) {
            String string3 = this.mView.getVideoUrl(string);
            if (this.mView.isAnAdfactoryUrl(string3)) {
                String string4 = this.mView.getVideoId(string3);
                this.findVideoData(string4);
            } else {
                this.playAlternativePlayer(string);
            }
        } else {
            this.playAlternativePlayer(string);
        }
    }

    @Override
    public void playAlternativePlayer(String string) {
        this.mView.playAlternativePlayer(string);
    }

    @Override
    public void findVideoData(String string) {
        this.mData.findVideoById(string, this);
    }

    @Override
    public void autoOrientation() {
        if (this.mView.isLandscape()) {
            this.mView.displayLandscapeMode();
        } else {
            this.mView.displayPortraitMode();
        }
    }

    @Override
    public void onReady(VideoModel videoModel) {
        if (videoModel.getReady().booleanValue()) {
            this.mView.loadVideo(videoModel);
        } else {
            this.playAlternativePlayer(this.mView.getEmbed());
        }
    }

    @Override
    public void onFailure(Exception exception) {
        this.mView.displayError(exception);
    }
}

