package adfactory.player.android.Video.data;

import adfactory.player.android.Models.VideoModel;
import adfactory.player.android.Utils.VideoRequestTask;
import adfactory.player.android.Video.VideoInteractor;

/**
 * Created by medyo on 3/15/18.
 */

public class VideoDataRepository implements VideoInteractor.Data {

    private String mApiKey;

    public VideoDataRepository(String apiKey){
        this.mApiKey = apiKey;
    }

    @Override
    public void findVideoById(String videoId, final VideoInteractor.onVideoReady callback) {

        new VideoRequestTask(videoId, mApiKey, new VideoRequestTask.onVideoReady() {
            @Override
            public void onComplete(VideoModel video) {
                callback.onReady(video);
            }

            @Override
            public void onError() {
                callback.onFailure(new Exception("not_found"));
            }
        }).execute();
    }
}
