package adfactory.player.android.Video;

import adfactory.player.android.Models.VideoModel;
import adfactory.player.android.Video.data.VideoDataRepository;

/**
 * Created by medyo on 3/14/18.
 */

public class VideoPresenter implements VideoInteractor.Presenter, VideoInteractor.onVideoReady {

    VideoInteractor.View mView;
    VideoDataRepository mData;

    public VideoPresenter(VideoInteractor.View view, VideoDataRepository data){
        this.mView = view;
        this.mData = data;
    }

    @Override
    public void onCreate(String embed) {
        if (!this.mView.isConfigured()){
            this.mView.displayError(new Exception("key"));
        } else {
            this.mView.hideError();
            this.checkVideo(embed);
        }
    }

    @Override
    public void checkVideo(String embed) {

        if (this.mView.isAnAdfactoryUrl(embed)){

            String videoId = this.mView.getVideoId(embed);

            this.findVideoData(videoId);

        } else if (!this.mView.getVideoUrl(embed).isEmpty()){

            String videoUrl = this.mView.getVideoUrl(embed);

            if (this.mView.isAnAdfactoryUrl(videoUrl)){

                String videoId = this.mView.getVideoId(videoUrl);

                this.findVideoData(videoId);

            } else {

                this.playAlternativePlayer(embed);
            }

        } else {

            this.playAlternativePlayer(embed);
        }
    }

    @Override
    public void playAlternativePlayer(String embed) {
        this.mView.playAlternativePlayer(embed);
    }

    @Override
    public void findVideoData(String videoId) {
        this.mData.findVideoById(videoId, this);
    }

    @Override
    public void autoOrientation() {
        if (mView.isLandscape()){
            mView.displayLandscapeMode();
        } else {
            mView.displayPortraitMode();
        }
    }

    @Override
    public void onReady(VideoModel video) {
        if (video.getReady()){
            this.mView.loadVideo(video);
        } else {

            this.playAlternativePlayer(this.mView.getEmbed());
        }
    }

    @Override
    public void onFailure(Exception e) {
        this.mView.displayError(e);
    }
}
