/*
 * Decompiled with CFR 0.152.
 */
package adfactory.player.android.Utils;

import adfactory.player.android.Models.VideoModel;
import android.os.AsyncTask;
import android.util.Log;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.json.JSONObject;

public class VideoRequestTask
extends AsyncTask<String, Void, VideoModel> {
    private onVideoReady mCallback;
    HttpURLConnection mConnection;
    String mVideoId;
    String mToken;

    public VideoRequestTask(String string, String string2, onVideoReady onVideoReady2) {
        Log.e((String)"Video Id", (String)string);
        this.mVideoId = string;
        this.mCallback = onVideoReady2;
        this.mToken = string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VideoModel doInBackground(String ... stringArray) {
        try {
            String string;
            URL uRL = new URL(String.format("http://api.adfactory.me/v1/video/%s/", this.mVideoId));
            this.mConnection = (HttpURLConnection)uRL.openConnection();
            this.mConnection.setRequestMethod("GET");
            this.mConnection.setRequestProperty("app-source", "adfactory.player.android");
            this.mConnection.setRequestProperty("app-token", this.mToken);
            this.mConnection.connect();
            int n = this.mConnection.getResponseCode();
            Log.e((String)"Status Code", (String)(n + ""));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.mConnection.getInputStream()));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string + "\n");
            }
            bufferedReader.close();
            VideoModel videoModel = new VideoModel();
            JSONObject jSONObject = new JSONObject(stringBuilder.toString());
            Log.e((String)"Json", (String)stringBuilder.toString());
            if (jSONObject.has("title")) {
                videoModel.setTitle(jSONObject.getString("title"));
            }
            if (jSONObject.has("is_ready")) {
                videoModel.setReady(jSONObject.getBoolean("is_ready"));
            }
            if (jSONObject.has("dfp_tag")) {
                videoModel.setDfp(jSONObject.getString("dfp_tag"));
            }
            if (jSONObject.has("html")) {
                videoModel.setEmbed(jSONObject.getString("html"));
            }
            if (jSONObject.has("mp4_sd")) {
                videoModel.setVideoSd(jSONObject.getString("mp4_sd"));
            }
            if (jSONObject.has("mp4_hd") && jSONObject.getString("mp4_hd") != null) {
                videoModel.setHasHd(true);
                videoModel.setVideoHd(jSONObject.getString("mp4_hd"));
            }
            VideoModel videoModel2 = videoModel;
            return videoModel2;
        }
        catch (Exception exception) {
            Log.e((String)"VideoRequestTask", (String)exception.getMessage());
        }
        finally {
            if (this.mConnection != null) {
                this.mConnection.disconnect();
            }
        }
        return null;
    }

    protected void onPostExecute(VideoModel videoModel) {
        super.onPostExecute((Object)videoModel);
        if (this.mCallback != null) {
            if (videoModel != null) {
                this.mCallback.onComplete(videoModel);
            } else {
                this.mCallback.onError();
            }
        }
    }

    public static interface onVideoReady {
        public void onComplete(VideoModel var1);

        public void onError();
    }
}

