package adfactory.player.android.Video;

import android.content.Context;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.support.v4.widget.ContentLoadingProgressBar;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.URLUtil;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.google.android.exoplayer2.DefaultLoadControl;
import com.google.android.exoplayer2.DefaultRenderersFactory;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.ExoPlayerFactory;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.ext.ima.ImaAdsLoader;
import com.google.android.exoplayer2.source.ExtractorMediaSource;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.source.ads.AdsMediaSource;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.ui.PlayerView;
import com.google.android.exoplayer2.upstream.DefaultHttpDataSourceFactory;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import adfactory.player.android.BuildConfig;
import adfactory.player.android.Models.VideoModel;
import adfactory.player.android.R;
import adfactory.player.android.Utils.Html5WebVideoView;
import adfactory.player.android.Utils.Utils;
import adfactory.player.android.Video.data.VideoDataRepository;
import adfactory.player.android.interfaces.onVideoReady;

/**
 * Created by medyo on 3/14/18.
 */

public class VideoView extends RelativeLayout implements VideoInteractor.View,
        VideoInteractor.VideoCommunicator {

    VideoPresenter mPresenter;

    RelativeLayout mWrapper;

    TextView mTextError;

    int mVideoViewBackgroundColor;

    onVideoReady mCallback;

    Boolean mSetupReady = false;

    Html5WebVideoView mWebView;

    int mSeekBarColor;

    String mEmbed;

    View mView;

    PlayerView mExoPlayerView;

    ExoPlayer mExoPlayerFactory;

    ContentLoadingProgressBar mProgressBar;

    View mFullScreenButton;

    private void initFullscreenButton() {

        mFullScreenButton = mView.findViewById(R.id.exo_fullscreen_icon);
        mFullScreenButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (!isLandscape()){
                    displayLandscapeMode();
                } else {
                    displayPortraitMode();
                }
            }
        });
    }


    public VideoView(Context context) {
        super(context);
        setupView();
    }

    public VideoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        setupView();
    }


    private void setupView() {

        mView = LayoutInflater.from(getContext()).inflate(R.layout.adfactory_player, this);

        // Resources
        mVideoViewBackgroundColor = ContextCompat.getColor(getContext(),
                R.color.adfactory_default_background_color);

        mSeekBarColor = Utils.getThemeAccentColor(getContext());

    }

    protected void onFinishInflate(){
        super.onFinishInflate();

        // FindByIds
        mWrapper        = mView.findViewById(R.id.wrapper);

        mTextError      = mView.findViewById(R.id.error_text_view);

        mWebView        = mView.findViewById(R.id.adfactory_webView);

        // Initialization
        mWrapper.setBackgroundColor(mVideoViewBackgroundColor);

    }

    public void setPayload(String embed){
        this.mEmbed = embed;

        mExoPlayerFactory = ExoPlayerFactory.newSimpleInstance(
                new DefaultRenderersFactory(getContext()),
                new DefaultTrackSelector(),
                new DefaultLoadControl());

        mExoPlayerFactory.setPlayWhenReady(true);
        mExoPlayerFactory.seekTo(0, 0);

        mPresenter = new VideoPresenter(this, new VideoDataRepository(Utils.getApiKey(getContext())));

        mPresenter.onCreate(mEmbed);
    }

    @Override
    public boolean isConfigured() {

        mSetupReady = !TextUtils.isEmpty(Utils.getApiKey(getContext()));

        if (!mSetupReady){
            Log.e("AdFactory", "Please add <meta-data android:name=\"com.adfactory.key\"\n" +
                    "            android:value=\"Your Api Key\" /> To your manifest file");
        }

        return mSetupReady;
    }

    @Override
    public boolean isLandscape() {

        int orientation = getResources().getConfiguration().orientation;

        return orientation == Configuration.ORIENTATION_LANDSCAPE ||
                (mFullScreenButton.getTag() != null && mFullScreenButton.getTag().equals("landscape"));
    }

    @Override
    public void displayLandscapeMode() {
        mFullScreenButton.setTag("landscape");
        getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN,  WindowManager.LayoutParams.FLAG_FULLSCREEN);
        getWindow().clearFlags(WindowManager.LayoutParams.FLAG_FORCE_NOT_FULLSCREEN);

        ViewGroup.LayoutParams params = mWrapper.getLayoutParams();
        params.width = LayoutParams.MATCH_PARENT;
        params.height = LayoutParams.MATCH_PARENT;

        mWrapper.setLayoutParams(params);

        if (mCallback != null){
            mCallback.onOrientationChange(true);
        }

        getWindow().getDecorView().requestLayout();
    }

    private Window getWindow(){
        return ((AppCompatActivity) getContext()).getWindow();
    }

    @Override
    public void displayPortraitMode() {

        mFullScreenButton.setTag("portrait");
        int videoHeight = getResources().getDimensionPixelSize(R.dimen.adfactory_video_height);

        getWindow().clearFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN);
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_FORCE_NOT_FULLSCREEN);

        ViewGroup.LayoutParams params = mWrapper.getLayoutParams();
        params.width = LayoutParams.MATCH_PARENT;
        params.height = videoHeight;

        mWrapper.setLayoutParams(params);
        if (mCallback != null){
            mCallback.onOrientationChange(false);
        }

        getWindow().getDecorView().requestLayout();
    }

    @Override
    public String getEmbed() {
        return mEmbed;
    }

    @Override
    public boolean isAnAdfactoryUrl(String embed) {

        if (URLUtil.isHttpUrl(embed) || URLUtil.isHttpsUrl(embed)){
            String domainName = Utils.getDomainName(embed);
            return Arrays.asList("cdnvideo", "adfactory").contains(domainName);
        }

        return false;
    }

    @Override
    public void displayError(Exception exception) {
        if (exception.getMessage().equalsIgnoreCase("key")){
            mTextError.setText(getResources().getString(R.string.adfactory_exception_missing_key));
        } else if (exception.getMessage().equalsIgnoreCase("not_found")){
            mTextError.setText((getResources().getString(R.string.adfactory_exception_video_not_found)));
        } else {
            mTextError.setText("Unknown Error");
        }

        mTextError.setVisibility(VISIBLE);
    }

    @Override
    public void hideError() {
        mTextError.setVisibility(GONE);
    }

    @Override
    public String getVideoId(String embed) {
        return Utils.extractVideoId(embed);
    }

    @Override
    public String getVideoUrl(String embed) {
        return Utils.extractVideoUrl(embed);
    }

    @Override
    public void playAlternativePlayer(String embed) {
        ViewStub videoWebViewStub = mView.findViewById(R.id.stub_video_web_view);
        videoWebViewStub.inflate();
        mWebView = mView.findViewById(R.id.adfactory_webView);
        mWebView.setAutoPlay(true);

        embed = embed.replace("https", "http");

        Pattern pattern = Pattern.compile("(?:width|height)=(?:(['\"\"])(.*?)\\1|.*)");
        Matcher m = pattern.matcher(embed);
        StringBuffer embedFixed = new StringBuffer(embed.length());
        while (m.find()) {
            m.appendReplacement(embedFixed, m.group(0).replaceAll("=(?:(['\"\"])(.*?)\\1|.*)", "=\"100%\""));
        }
        m.appendTail(embedFixed);

        String wrapper = "<html><body style='margin:0;padding:0;height:100%;width:100%'>"+embedFixed+"</body><html>";
        mWebView.loadData(wrapper, "text/html", "UTF-8");
    }

    @Override
    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        mPresenter.autoOrientation();
    }

    @Override
    public void loadVideo(VideoModel video) {

        ViewStub videoPlayerStub = mView.findViewById(R.id.stub_video_player);
        videoPlayerStub.inflate();

        mExoPlayerView  = mView.findViewById(R.id.adfactory_video_view2);
        mExoPlayerView.setPlayer(mExoPlayerFactory);

        mProgressBar = findViewById(R.id.adfactory_progress_bar);

        mExoPlayerFactory.addListener(new Player.EventListener() {
            @Override
            public void onTimelineChanged(Timeline timeline, Object manifest, int reason) {

            }

            @Override
            public void onTracksChanged(TrackGroupArray trackGroups, TrackSelectionArray trackSelections) {

            }

            @Override
            public void onLoadingChanged(boolean isLoading) {

            }

            @Override
            public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
                if (playbackState == Player.STATE_BUFFERING){
                    mProgressBar.show();
                    mExoPlayerView.findViewById(R.id.exo_play).setVisibility(GONE);
                    mExoPlayerView.findViewById(R.id.exo_pause).setVisibility(GONE);
                } else {
                    mProgressBar.hide();
                    if (mExoPlayerView.getPlayer().getPlayWhenReady()) {
                        mExoPlayerView.hideController();
                    } else {
                        mExoPlayerView.showController();
                    }

                }
            }

            @Override
            public void onRepeatModeChanged(int repeatMode) {

            }

            @Override
            public void onShuffleModeEnabledChanged(boolean shuffleModeEnabled) {

            }

            @Override
            public void onPlayerError(ExoPlaybackException error) {

            }

            @Override
            public void onPositionDiscontinuity(int reason) {

            }

            @Override
            public void onPlaybackParametersChanged(PlaybackParameters playbackParameters) {

            }

            @Override
            public void onSeekProcessed() {

            }
        });

        String videoUrl = getResources().getString(R.string.adfactory_sample_video_url);
        if (BuildConfig.DEBUG){
            videoUrl = video.getVideoSd();
        }

        String dfpUrl = getResources().getString(R.string.adfactory_sample_ad_tag_url);
        if (!BuildConfig.DEBUG){
            dfpUrl = video.getDfp();
        }

        ImaAdsLoader imaAdsLoader = new ImaAdsLoader(getContext(), Uri.parse(dfpUrl));


        DefaultHttpDataSourceFactory dataSource =
                new DefaultHttpDataSourceFactory("elbotola-app");

        Map<String, String> headers = new HashMap<>();
        headers.put("Referer", videoUrl);
        headers.put("app-source", BuildConfig.APPLICATION_ID);
        dataSource.getDefaultRequestProperties().set(headers);

        MediaSource mediaSource = new ExtractorMediaSource.Factory(dataSource).
                createMediaSource(Uri.parse(videoUrl));


        MediaSource mediaSourceWithAds = new AdsMediaSource(
                mediaSource,
                dataSource,
                imaAdsLoader,
                mExoPlayerView.getOverlayFrameLayout());

        mExoPlayerFactory.prepare(mediaSourceWithAds, true, false);


        initFullscreenButton();
    }

    @Override
    public void pauseVideo() {

        if (mWebView != null){
            try{
                Class.forName("android.webkit.WebView").getMethod("onPause", (Class[]) null).invoke(mWebView, (Object[]) null);
            } catch(Exception e){}

            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB){
                mWebView.onPause();
            }
            mWebView.stopLoading();
            mWebView.loadUrl("about:blank");
            mWebView.reload();
            mWebView = null;
        }
    }

    @Override
    public void onError(Exception e) {
        if (mPresenter != null){
            mPresenter.onFailure(e);
        }
    }
}
