package adfactory.player.android.Utils;

import android.os.AsyncTask;
import android.util.Log;

import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

import adfactory.player.android.BuildConfig;
import adfactory.player.android.Models.VideoModel;

/**
 * Created by medyo on 9/26/16.
 */
public class VideoRequestTask extends AsyncTask<String, Void, VideoModel>  {


    private onVideoReady mCallback;
    HttpURLConnection mConnection;
    String mVideoId, mToken;

    public VideoRequestTask(String videoId, String token, onVideoReady callback){
        Log.e("Video Id", videoId);
        this.mVideoId = videoId;
        this.mCallback = callback;
        this.mToken = token;
    }


    @Override
    protected VideoModel doInBackground(String... strings) {
        try {

            URL url = new URL(String.format("http://api.adfactory.me/v1/video/%s/", mVideoId));
            mConnection = (HttpURLConnection) url.openConnection();
            mConnection.setRequestMethod("GET");
            mConnection.setRequestProperty("app-source", BuildConfig.APPLICATION_ID);
            mConnection.setRequestProperty("app-token", mToken);

            mConnection.connect();

            int responseCode = mConnection.getResponseCode();
            Log.e("Status Code", responseCode+"");
            BufferedReader br = new BufferedReader(new InputStreamReader(mConnection.getInputStream()));
            StringBuilder sb = new StringBuilder();
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
            }
            br.close();

            VideoModel videoModel = new VideoModel();

            JSONObject jsonObject = new JSONObject(sb.toString());

            Log.e("Json", sb.toString());

            if (jsonObject.has("title")){
                videoModel.setTitle(jsonObject.getString("title"));
            }

            if (jsonObject.has("is_ready")){
                videoModel.setReady(jsonObject.getBoolean("is_ready"));
            }

            if (jsonObject.has("dfp_tag")){
                videoModel.setDfp(jsonObject.getString("dfp_tag"));
            }

            if (jsonObject.has("html")){
                videoModel.setEmbed(jsonObject.getString("html"));
            }

            if (jsonObject.has("mp4_sd")){
                videoModel.setVideoSd(jsonObject.getString("mp4_sd"));
            }

            if (jsonObject.has("mp4_hd") && jsonObject.getString("mp4_hd") != null){
                videoModel.setHasHd(true);
                videoModel.setVideoHd(jsonObject.getString("mp4_hd"));
            }

            return videoModel;

        } catch (Exception e) {
            Log.e("VideoRequestTask", e.getMessage());
        } finally {

            if (mConnection != null) {
                mConnection.disconnect();
            }
        }
        return null;
    }

    @Override
    protected void onPostExecute(VideoModel video) {
        super.onPostExecute(video);
        if (mCallback != null){

            if (video != null){
                mCallback.onComplete(video);
            } else {
                mCallback.onError();
            }

        }
    }

    public interface onVideoReady{
        void onComplete(VideoModel video);
        void onError();
    }
}
