/*
 * Decompiled with CFR 0.152.
 */
package adfactory.player.android;

import adfactory.player.android.R;
import adfactory.player.android.interfaces.IVideoPlayer;
import android.content.Context;
import android.media.MediaPlayer;
import android.util.AttributeSet;
import android.widget.VideoView;
import java.util.ArrayList;
import java.util.List;

public class AdFactoryVideoView
extends VideoView
implements IVideoPlayer {
    int mVideoViewHeight;
    private final List<IVideoPlayer.IPlayerCallback> mVideoPlayerCallbacks = new ArrayList<IVideoPlayer.IPlayerCallback>(1);
    private PlaybackState mPlaybackState;

    public AdFactoryVideoView(Context context) {
        super(context);
        this.initialize();
    }

    public AdFactoryVideoView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initialize();
    }

    private void initialize() {
        this.mVideoViewHeight = this.getResources().getDimensionPixelSize(R.dimen.adfactory_video_height);
        this.mPlaybackState = PlaybackState.STOPPED;
        super.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mediaPlayer) {
                AdFactoryVideoView.this.mPlaybackState = PlaybackState.STOPPED;
                for (IVideoPlayer.IPlayerCallback iPlayerCallback : AdFactoryVideoView.this.mVideoPlayerCallbacks) {
                    iPlayerCallback.onCompleted();
                }
            }
        });
        super.setOnErrorListener(new MediaPlayer.OnErrorListener(){

            public boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
                AdFactoryVideoView.this.mPlaybackState = PlaybackState.STOPPED;
                for (IVideoPlayer.IPlayerCallback iPlayerCallback : AdFactoryVideoView.this.mVideoPlayerCallbacks) {
                    iPlayerCallback.onError(mediaPlayer, n, n2);
                }
                return true;
            }
        });
        super.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mediaPlayer) {
                for (IVideoPlayer.IPlayerCallback iPlayerCallback : AdFactoryVideoView.this.mVideoPlayerCallbacks) {
                    iPlayerCallback.onPrepare();
                }
            }
        });
    }

    public void start() {
        super.start();
        switch (this.mPlaybackState) {
            case STOPPED: {
                for (IVideoPlayer.IPlayerCallback iPlayerCallback : this.mVideoPlayerCallbacks) {
                    iPlayerCallback.onPlay();
                }
                break;
            }
            case PAUSED: {
                for (IVideoPlayer.IPlayerCallback iPlayerCallback : this.mVideoPlayerCallbacks) {
                    iPlayerCallback.onResume();
                }
                break;
            }
        }
        this.mPlaybackState = PlaybackState.PLAYING;
    }

    @Override
    public void play() {
        this.start();
    }

    @Override
    public void stopPlayback() {
        super.stopPlayback();
        this.mPlaybackState = PlaybackState.STOPPED;
    }

    @Override
    public void addPlayerCallback(IVideoPlayer.IPlayerCallback iPlayerCallback) {
        this.mVideoPlayerCallbacks.add(iPlayerCallback);
    }

    public void setOnCompletionListener(MediaPlayer.OnCompletionListener onCompletionListener) {
        throw new UnsupportedOperationException();
    }

    public void setOnErrorListener(MediaPlayer.OnErrorListener onErrorListener) {
        throw new UnsupportedOperationException();
    }

    public void setOnPreparedListener(MediaPlayer.OnPreparedListener onPreparedListener) {
        throw new UnsupportedOperationException();
    }

    protected void onMeasure(int n, int n2) {
        int n3 = AdFactoryVideoView.getDefaultSize((int)0, (int)n);
        int n4 = AdFactoryVideoView.getDefaultSize((int)0, (int)n2);
        this.setMeasuredDimension(n3, n4);
    }

    private static enum PlaybackState {
        STOPPED,
        PAUSED,
        PLAYING;

    }
}

