/*
 * Decompiled with CFR 0.152.
 */
package adfactory.player.android.Utils;

import adfactory.player.android.R;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.graphics.drawable.VectorDrawableCompat;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.text.TextUtils;
import android.util.Log;
import android.util.TypedValue;
import android.webkit.URLUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
    public static StateListDrawable loadVectorDrawable(Context context, int n) {
        VectorDrawableCompat vectorDrawableCompat = VectorDrawableCompat.create((Resources)context.getResources(), (int)n, (Resources.Theme)context.getTheme());
        Drawable drawable2 = vectorDrawableCompat.getConstantState().newDrawable().mutate();
        DrawableCompat.setTint((Drawable)drawable2, (int)ContextCompat.getColor((Context)context, (int)R.color.adfactory_controllers_focus_color));
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16842908, -16842919}, (Drawable)vectorDrawableCompat);
        stateListDrawable.addState(new int[]{16842908, 16842919}, drawable2);
        stateListDrawable.addState(new int[]{-16842908, 16842919}, drawable2);
        stateListDrawable.addState(new int[0], (Drawable)vectorDrawableCompat);
        return stateListDrawable;
    }

    public static String getApiKey(Context context) {
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = applicationInfo.metaData;
            return bundle.getString("com.adfactory.key");
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String milliSecondsToTimer(long l) {
        String string2 = "";
        String string3 = "";
        int n = (int)(l / 3600000L);
        int n2 = (int)(l % 3600000L) / 60000;
        int n3 = (int)(l % 3600000L % 60000L / 1000L);
        if (n > 0) {
            string2 = n + ":";
        }
        string3 = n3 < 10 ? "0" + n3 : "" + n3;
        string2 = string2 + n2 + ":" + string3;
        return string2;
    }

    public static String extractVideoId(String string2) {
        String string3 = "";
        if (string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        Uri uri = Uri.parse((String)string2);
        string3 = uri.getLastPathSegment();
        return string3;
    }

    public static String extractVideoUrl(String string2) {
        Pattern pattern = Pattern.compile("src=\"([^\"]+)\"");
        Matcher matcher = pattern.matcher(string2);
        String string3 = "";
        while (matcher.find()) {
            Log.e((String)"Find", (String)matcher.group(1));
            string3 = matcher.group(1);
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            string3 = Utils.addMissingHttp(string3);
        }
        return string3;
    }

    public static String addMissingHttp(String string2) {
        if (!string2.startsWith("http")) {
            if (string2.startsWith("//")) {
                return String.format("http:%s", string2);
            }
            return String.format("http://%s", string2);
        }
        return string2;
    }

    public static int getThemeAccentColor(Context context) {
        int n = Build.VERSION.SDK_INT >= 21 ? 16843829 : context.getResources().getIdentifier("colorAccent", "attr", context.getPackageName());
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(n, typedValue, true);
        return typedValue.data;
    }

    public static String getDomainName(String string2) {
        if (!URLUtil.isHttpUrl((String)string2) && !URLUtil.isHttpsUrl((String)string2)) {
            return "";
        }
        URI uRI = null;
        try {
            uRI = new URI(string2);
            String string3 = uRI.getHost();
            string3 = string3.toLowerCase();
            string3 = string3.startsWith("www.") ? string3.substring(4) : string3;
            int n = string3.lastIndexOf(46) > -1 ? string3.lastIndexOf(46) : string3.length();
            string3 = string3.substring(0, n);
            String[] stringArray = string3.split("\\.");
            if (stringArray.length > 0) {
                return stringArray[stringArray.length - 1];
            }
            return stringArray[0];
        }
        catch (URISyntaxException uRISyntaxException) {
            return "";
        }
    }
}

