/*
 * Decompiled with CFR 0.152.
 */
package adfactory.player.android;

import adfactory.player.android.AdFactory;
import adfactory.player.android.AdFactoryPlayerControllers;
import adfactory.player.android.AdFactoryVideoView;
import adfactory.player.android.Models.VideoModel;
import adfactory.player.android.R;
import adfactory.player.android.Utils.Html5WebVideoView;
import adfactory.player.android.Utils.Utils;
import adfactory.player.android.Utils.VideoRequestTask;
import adfactory.player.android.VideoLoader;
import adfactory.player.android.interfaces.onVideoReady;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.view.Window;
import android.webkit.URLUtil;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AdFactoryPlayer
extends RelativeLayout {
    RelativeLayout mWrapper;
    TextView mTextError;
    AdFactoryVideoView mVideoView;
    View mRootView;
    VideoLoader mVideoLoader;
    int mVideoViewBackgroundColor;
    AdFactoryPlayerControllers mControllers;
    AdFactory mAdFactory;
    String mVideoUrl;
    String mVideoId;
    onVideoReady mCallback;
    Boolean mSetupReady = false;
    Html5WebVideoView mWebView;
    String mApiKey;
    int mSeekBarColor;
    VideoModel mVideoModel;

    public AdFactoryPlayer(Context context) {
        super(context);
        this.initView();
    }

    public AdFactoryPlayer(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initView();
    }

    public void setUrl(String string2) {
        this.mVideoUrl = string2;
    }

    public void initView() {
        this.mRootView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.adfactory_player, (ViewGroup)this);
        this.mVideoViewBackgroundColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.adfactory_default_background_color);
        this.mWrapper = (RelativeLayout)this.mRootView.findViewById(R.id.wrapper);
        this.mWrapper.setBackgroundColor(this.mVideoViewBackgroundColor);
        this.mSeekBarColor = Utils.getThemeAccentColor(this.getContext());
        this.mTextError = (TextView)this.mRootView.findViewById(R.id.error_text_view);
        this.mApiKey = Utils.getApiKey(this.getContext());
        this.mSetupReady = !TextUtils.isEmpty((CharSequence)this.mApiKey);
        if (!this.mSetupReady.booleanValue()) {
            Log.e((String)"AdFactory", (String)"Please add <meta-data android:name=\"com.adfactory.key\"\n            android:value=\"Your Api Key\" /> To your manifest file");
            this.displayError(this.getContext().getResources().getString(R.string.adfactory_exception_missing_key));
        } else {
            this.mTextError.setVisibility(8);
        }
    }

    public void setCallback(onVideoReady onVideoReady2) {
        this.mCallback = onVideoReady2;
    }

    private void displayError(String string2) {
        this.mTextError.setText((CharSequence)string2);
        this.mTextError.setVisibility(0);
    }

    public void play(final String string2) {
        this.mVideoUrl = string2;
        if (this.mSetupReady.booleanValue()) {
            if (URLUtil.isHttpUrl((String)string2) || URLUtil.isHttpsUrl((String)string2)) {
                String string3 = Utils.getDomainName(string2);
                if (Arrays.asList("cdnvideo", "adfactory").contains(string3)) {
                    this.mVideoId = Utils.extractVideoId(string2);
                } else {
                    this.inflateWebView(string2);
                }
            } else {
                this.mVideoUrl = Utils.extractVideoUrl(string2);
                Log.e((String)"Video URl", (String)(this.mVideoUrl + " <---"));
                if (!TextUtils.isEmpty((CharSequence)this.mVideoUrl)) {
                    String string4 = Utils.getDomainName(this.mVideoUrl);
                    Log.e((String)"domain", (String)string4);
                    String[] stringArray = new String[]{"cdnvideo", "adfactory"};
                    if (Arrays.asList(stringArray).contains(string4)) {
                        this.mVideoId = Utils.extractVideoId(this.mVideoUrl);
                        Log.e((String)"Video Id", (String)("-->" + this.mVideoId));
                    }
                }
                if (TextUtils.isEmpty((CharSequence)this.mVideoId)) {
                    this.inflateWebView(string2);
                    Log.i((String)"adfactory", (String)this.getResources().getString(R.string.adfactory_exception_video_not_found));
                } else {
                    new VideoRequestTask(this.mVideoId, this.mApiKey, new VideoRequestTask.onVideoReady(){

                        @Override
                        public void onComplete(VideoModel videoModel) {
                            AdFactoryPlayer.this.mVideoModel = videoModel;
                            if (videoModel.getReady().booleanValue()) {
                                ViewStub viewStub = (ViewStub)AdFactoryPlayer.this.mRootView.findViewById(R.id.stub_video_player);
                                viewStub.inflate();
                                AdFactoryPlayer.this.mVideoView = (AdFactoryVideoView)AdFactoryPlayer.this.mRootView.findViewById(R.id.adfactory_video_view);
                                AdFactoryPlayer.this.mControllers = (AdFactoryPlayerControllers)AdFactoryPlayer.this.mRootView.findViewById(R.id.adfactory_controllers);
                                AdFactoryPlayer.this.mAdFactory = new AdFactory(AdFactoryPlayer.this.mVideoView, (ViewGroup)AdFactoryPlayer.this.mWrapper, videoModel.getVideoSd());
                                AdFactoryPlayer.this.mControllers.setup(AdFactoryPlayer.this.mVideoView, AdFactoryPlayer.this.mAdFactory, AdFactoryPlayer.this.mSeekBarColor, AdFactoryPlayer.this.mCallback);
                                AdFactoryPlayer.this.mControllers.initialize();
                                AdFactoryPlayer.this.mVideoLoader = new VideoLoader(AdFactoryPlayer.this.getContext(), AdFactoryPlayer.this.mAdFactory, AdFactoryPlayer.this.mControllers, videoModel.getDfp());
                                AdFactoryPlayer.this.mVideoLoader.setup();
                                AdFactoryPlayer.this.mVideoLoader.play();
                            } else {
                                AdFactoryPlayer.this.inflateWebView(string2);
                            }
                        }

                        @Override
                        public void onError() {
                            Log.e((String)"Error", (String)"Error");
                            AdFactoryPlayer.this.displayError(AdFactoryPlayer.this.getResources().getString(R.string.adfactory_exception_video_not_found));
                        }
                    }).execute(new String[0]);
                }
            }
        }
    }

    private void inflateWebView(String string2) {
        ViewStub viewStub = (ViewStub)this.mRootView.findViewById(R.id.stub_video_web_view);
        viewStub.inflate();
        this.mWebView = (Html5WebVideoView)this.mRootView.findViewById(R.id.adfactory_webView);
        this.mWebView.setAutoPlay(true);
        string2 = string2.replace("https", "http");
        Pattern pattern = Pattern.compile("(?:width|height)=(?:(['\"\"])(.*?)\\1|.*)");
        Matcher matcher = pattern.matcher(string2);
        StringBuffer stringBuffer = new StringBuffer(string2.length());
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, matcher.group(0).replaceAll("=(?:(['\"\"])(.*?)\\1|.*)", "=\"100%\""));
        }
        matcher.appendTail(stringBuffer);
        String string3 = "<html><body style='margin:0;padding:0;height:100%;width:100%'>" + stringBuffer + "</body><html>";
        this.mWebView.loadData(string3, "text/html", "UTF-8");
    }

    public void resume() {
        if (this.mVideoLoader != null) {
            this.mVideoLoader.resume();
        }
    }

    public void pause() {
        if (this.mVideoLoader != null) {
            this.mVideoLoader.pause();
        }
        if (this.mWebView != null) {
            try {
                Class.forName("android.webkit.WebView").getMethod("onPause", null).invoke((Object)this.mWebView, (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (Build.VERSION.SDK_INT >= 11) {
                this.mWebView.onPause();
            }
            this.mWebView.stopLoading();
            this.mWebView.loadUrl("about:blank");
            this.mWebView.reload();
            this.mWebView = null;
        }
    }

    protected void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.handleOrientation();
    }

    protected void handleOrientation() {
        int n = this.getResources().getConfiguration().orientation;
        boolean bl = n == 2;
        int n2 = this.getResources().getDimensionPixelSize(R.dimen.adfactory_video_height);
        if (bl) {
            this.getWindow().setFlags(1024, 1024);
            this.getWindow().clearFlags(2048);
            ViewGroup.LayoutParams layoutParams = this.mWrapper.getLayoutParams();
            layoutParams.width = -1;
            layoutParams.height = -1;
            this.mWrapper.setLayoutParams(layoutParams);
            if (this.mCallback != null) {
                this.mCallback.onOrientationChange(true);
            }
        } else {
            this.getWindow().clearFlags(1024);
            this.getWindow().addFlags(2048);
            ViewGroup.LayoutParams layoutParams = this.mWrapper.getLayoutParams();
            layoutParams.width = -1;
            layoutParams.height = n2;
            this.mWrapper.setLayoutParams(layoutParams);
            if (this.mCallback != null) {
                this.mCallback.onOrientationChange(false);
            }
        }
        this.getWindow().getDecorView().requestLayout();
    }

    private Window getWindow() {
        return ((AppCompatActivity)this.getContext()).getWindow();
    }

    public AdFactoryPlayerControllers getControllers() {
        return this.mControllers;
    }

    public void setSeekBarColor(int n) {
        this.mSeekBarColor = n;
    }
}

