/*
 * Decompiled with CFR 0.152.
 */
package adfactory.player.android;

import adfactory.player.android.AdFactoryVideoView;
import adfactory.player.android.interfaces.IVideoPlayer;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import android.view.ViewGroup;
import android.widget.VideoView;
import com.google.ads.interactivemedia.v3.api.player.ContentProgressProvider;
import com.google.ads.interactivemedia.v3.api.player.VideoAdPlayer;
import com.google.ads.interactivemedia.v3.api.player.VideoProgressUpdate;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AdFactory {
    private AdFactoryVideoView mAdFactoryVideoView;
    private VideoAdPlayer mVideoAdPlayer;
    private boolean mIsAdDisplayed;
    private String mContentVideoUrl;
    private int mSavedVideoPosition;
    private boolean mIsContentComplete;
    private ContentProgressProvider mContentProgressProvider;
    private OnContentCompleteListener mOnContentCompleteListener;
    private OnContentPreparedListener mOnContentPreparedListener;
    private final List<VideoAdPlayer.VideoAdPlayerCallback> mAdCallbacks = new ArrayList<VideoAdPlayer.VideoAdPlayerCallback>(1);
    private ViewGroup mAdUiContainer;

    public AdFactory(AdFactoryVideoView adFactoryVideoView, ViewGroup viewGroup, String string) {
        this.mAdFactoryVideoView = adFactoryVideoView;
        this.mAdUiContainer = viewGroup;
        this.mContentVideoUrl = string;
    }

    public void initialize() {
        this.mIsAdDisplayed = false;
        this.mSavedVideoPosition = 0;
        this.mIsContentComplete = false;
        Log.e((String)"AdFactory.java", (String)"initialize");
        this.mVideoAdPlayer = new VideoAdPlayer(){

            public VideoProgressUpdate getAdProgress() {
                if (!AdFactory.this.mIsAdDisplayed || AdFactory.this.mAdFactoryVideoView.getDuration() <= 0) {
                    return VideoProgressUpdate.VIDEO_TIME_NOT_READY;
                }
                return new VideoProgressUpdate((long)AdFactory.this.mAdFactoryVideoView.getCurrentPosition(), (long)AdFactory.this.mAdFactoryVideoView.getDuration());
            }

            public void playAd() {
                AdFactory.this.mIsAdDisplayed = true;
                AdFactory.this.mAdFactoryVideoView.play();
            }

            public void loadAd(String string) {
                Log.e((String)"AdFactory.java", (String)"loadAd");
                AdFactory.this.mIsAdDisplayed = true;
                AdFactory.this.mAdFactoryVideoView.setVideoPath(string);
            }

            public void stopAd() {
                AdFactory.this.mAdFactoryVideoView.stopPlayback();
            }

            public void pauseAd() {
                AdFactory.this.mAdFactoryVideoView.pause();
            }

            public void resumeAd() {
                this.playAd();
            }

            public void addCallback(VideoAdPlayer.VideoAdPlayerCallback videoAdPlayerCallback) {
                AdFactory.this.mAdCallbacks.add(videoAdPlayerCallback);
            }

            public void removeCallback(VideoAdPlayer.VideoAdPlayerCallback videoAdPlayerCallback) {
                AdFactory.this.mAdCallbacks.remove(videoAdPlayerCallback);
            }
        };
        this.mContentProgressProvider = new ContentProgressProvider(){

            public VideoProgressUpdate getContentProgress() {
                if (AdFactory.this.mIsAdDisplayed || AdFactory.this.mAdFactoryVideoView.getDuration() <= 0) {
                    return VideoProgressUpdate.VIDEO_TIME_NOT_READY;
                }
                return new VideoProgressUpdate((long)AdFactory.this.mAdFactoryVideoView.getCurrentPosition(), (long)AdFactory.this.mAdFactoryVideoView.getDuration());
            }
        };
        this.mAdFactoryVideoView.addPlayerCallback(new IVideoPlayer.IPlayerCallback(){

            @Override
            public void onPlay() {
                if (AdFactory.this.mIsAdDisplayed) {
                    Log.d((String)"AdFactory", (String)"onPlay");
                    for (VideoAdPlayer.VideoAdPlayerCallback videoAdPlayerCallback : AdFactory.this.mAdCallbacks) {
                        videoAdPlayerCallback.onPlay();
                    }
                }
            }

            @Override
            public void onCompleted() {
                Log.d((String)"AdFactory", (String)"onCompleted");
                if (AdFactory.this.mIsAdDisplayed) {
                    for (VideoAdPlayer.VideoAdPlayerCallback videoAdPlayerCallback : AdFactory.this.mAdCallbacks) {
                        videoAdPlayerCallback.onEnded();
                    }
                } else {
                    if (AdFactory.this.mOnContentCompleteListener != null) {
                        AdFactory.this.mOnContentCompleteListener.onContentComplete();
                    }
                    AdFactory.this.mIsContentComplete = true;
                }
            }

            @Override
            public void onError(MediaPlayer mediaPlayer, int n, int n2) {
                Log.e((String)"AdFactory.java", (String)"onError");
                if (AdFactory.this.mIsAdDisplayed) {
                    for (VideoAdPlayer.VideoAdPlayerCallback videoAdPlayerCallback : AdFactory.this.mAdCallbacks) {
                        videoAdPlayerCallback.onError();
                    }
                }
            }

            @Override
            public void onPause() {
                if (AdFactory.this.mIsAdDisplayed) {
                    Log.d((String)"AdFactory", (String)"onPause");
                    for (VideoAdPlayer.VideoAdPlayerCallback videoAdPlayerCallback : AdFactory.this.mAdCallbacks) {
                        videoAdPlayerCallback.onPause();
                    }
                }
            }

            @Override
            public void onResume() {
                if (AdFactory.this.mIsAdDisplayed) {
                    Log.e((String)"AdFactory.java", (String)"onResume");
                    for (VideoAdPlayer.VideoAdPlayerCallback videoAdPlayerCallback : AdFactory.this.mAdCallbacks) {
                        videoAdPlayerCallback.onResume();
                    }
                }
            }

            @Override
            public void onPrepare() {
                Log.e((String)"AdFactory.java", (String)"onPrepare");
                if (!AdFactory.this.mIsAdDisplayed) {
                    if (AdFactory.this.mOnContentPreparedListener != null) {
                        AdFactory.this.mOnContentPreparedListener.onContentPrepared();
                    }
                    AdFactory.this.mIsContentComplete = true;
                }
            }
        });
    }

    public void savePosition() {
        this.mSavedVideoPosition = this.mAdFactoryVideoView.getCurrentPosition();
    }

    public void pauseContentForAdPlayback() {
        this.savePosition();
        this.mAdFactoryVideoView.stopPlayback();
    }

    public void restorePosition() {
        this.mAdFactoryVideoView.seekTo(this.mSavedVideoPosition);
    }

    public ViewGroup getAdUiContainer() {
        return this.mAdUiContainer;
    }

    public boolean getIsAdDisplayed() {
        return this.mIsAdDisplayed;
    }

    public ContentProgressProvider getContentProgressProvider() {
        return this.mContentProgressProvider;
    }

    public VideoAdPlayer getVideoAdPlayer() {
        return this.mVideoAdPlayer;
    }

    public void setOnContentCompleteListener(OnContentCompleteListener onContentCompleteListener) {
        this.mOnContentCompleteListener = onContentCompleteListener;
    }

    public void setOnContentPreparedListener(OnContentPreparedListener onContentPreparedListener) {
        this.mOnContentPreparedListener = onContentPreparedListener;
    }

    public void resumeContentAfterAdPlayback() {
        this.mIsAdDisplayed = false;
        if (!TextUtils.isEmpty((CharSequence)this.mContentVideoUrl)) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("Referer", this.mContentVideoUrl);
            hashMap.put("app-source", "adfactory.player.android");
            if (Build.VERSION.SDK_INT >= 21) {
                this.mAdFactoryVideoView.setVideoURI(Uri.parse((String)this.mContentVideoUrl), hashMap);
            } else {
                this.mAdFactoryVideoView.setVideoURI(Uri.parse((String)this.mContentVideoUrl));
                try {
                    Field field = VideoView.class.getDeclaredField("mHeaders");
                    field.setAccessible(true);
                    field.set(this.mAdFactoryVideoView, hashMap);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        } else {
            this.mAdFactoryVideoView.setVideoPath(this.mContentVideoUrl);
        }
        this.mAdFactoryVideoView.setVideoPath(this.mContentVideoUrl);
        this.restorePosition();
        if (!this.mIsContentComplete) {
            this.mAdFactoryVideoView.play();
        } else {
            this.mAdFactoryVideoView.stopPlayback();
        }
    }

    public void play() {
        this.mIsContentComplete = false;
        this.mAdFactoryVideoView.setVideoPath(this.mContentVideoUrl);
        this.mAdFactoryVideoView.start();
    }

    public static interface OnContentPreparedListener {
        public void onContentPrepared();
    }

    public static interface OnContentCompleteListener {
        public void onContentComplete();
    }
}

