/*
 * Decompiled with CFR 0.152.
 */
package adfactory.player.android.Utils;

import android.app.Activity;
import android.content.Context;
import android.media.MediaPlayer;
import android.os.Build;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.VideoView;

public class Html5WebVideoView
extends WebView {
    private WebSettings mWebSettings;
    private WebChromeClient mChromeClient;
    private VideoView mCustomVideoView;
    private WebChromeClient.CustomViewCallback mViewCallback;
    private FrameLayout mVideoLayout;
    private boolean mIsFullscreen = false;
    private FrameLayout mRootLayout;
    private boolean mAllowAutomaticNativeFullscreen = false;
    private boolean mAutoPlay = false;

    public Html5WebVideoView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public Html5WebVideoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public Html5WebVideoView(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        this.mRootLayout = (FrameLayout)((Activity)this.getContext()).getWindow().getDecorView();
        this.mWebSettings = this.getSettings();
        this.mWebSettings = this.getSettings();
        this.mWebSettings.setJavaScriptEnabled(true);
        this.mWebSettings.setPluginState(WebSettings.PluginState.ON);
        this.mWebSettings.setJavaScriptCanOpenWindowsAutomatically(false);
        this.mWebSettings.setSupportMultipleWindows(false);
        this.mWebSettings.setSupportZoom(false);
        this.mWebSettings.setLoadWithOverviewMode(true);
        if (Build.VERSION.SDK_INT >= 17) {
            this.mWebSettings.setMediaPlaybackRequiresUserGesture(false);
        }
        this.setVerticalScrollBarEnabled(false);
        this.setHorizontalScrollBarEnabled(false);
        this.setInitialScale(0);
        this.setWebChromeClient(new WebChromeClient());
        this.mChromeClient = new WebChromeClient(){

            public View getVideoLoadingProgressView() {
                ProgressBar pb = new ProgressBar(Html5WebVideoView.this.getContext());
                pb.setIndeterminate(true);
                return pb;
            }

            public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
                super.onShowCustomView(view, callback);
                ((Activity)Html5WebVideoView.this.getContext()).setVolumeControlStream(3);
                Html5WebVideoView.this.mIsFullscreen = true;
                Html5WebVideoView.this.mViewCallback = callback;
                if (view instanceof FrameLayout) {
                    FrameLayout frame = (FrameLayout)view;
                    if (frame.getFocusedChild() instanceof VideoView) {
                        VideoView video = (VideoView)frame.getFocusedChild();
                        frame.removeView((View)video);
                        Html5WebVideoView.this.setupVideoLayout((View)video);
                        Html5WebVideoView.this.mCustomVideoView = video;
                        Html5WebVideoView.this.mCustomVideoView.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                            public void onCompletion(MediaPlayer mediaPlayer) {
                                Html5WebVideoView.this.hideVideoView();
                            }
                        });
                    } else {
                        Html5WebVideoView.this.setupVideoLayout(view);
                    }
                }
            }

            public void onShowCustomView(View view, int requestedOrientation, WebChromeClient.CustomViewCallback callback) {
                this.onShowCustomView(view, callback);
            }

            public void onHideCustomView() {
                Html5WebVideoView.this.hideVideoView();
            }
        };
        this.setWebChromeClient(this.mChromeClient);
    }

    private void callPlayerMethod(String method) {
        this.loadUrl("javascript:player.api(\"" + method + "\")");
    }

    public void setVideoUrl(String url) {
        this.loadUrl(url);
    }

    public void hideVideoView() {
        if (this.isFullscreen()) {
            if (this.mCustomVideoView != null) {
                this.mCustomVideoView.stopPlayback();
            }
            this.mRootLayout.removeView((View)this.mVideoLayout);
            this.mViewCallback.onCustomViewHidden();
            ((Activity)this.getContext()).setVolumeControlStream(Integer.MIN_VALUE);
            this.mIsFullscreen = false;
        }
    }

    private void setupVideoLayout(View video) {
        this.mVideoLayout = new FrameLayout(this.getContext()){

            public boolean dispatchKeyEvent(KeyEvent event) {
                if (event.getKeyCode() == 4 && event.getAction() == 1) {
                    Html5WebVideoView.this.hideVideoView();
                    return true;
                }
                return super.dispatchKeyEvent(event);
            }
        };
        if (Build.VERSION.SDK_INT >= 14) {
            int uiOptions = 6;
            this.mVideoLayout.setSystemUiVisibility(uiOptions);
        }
        this.mVideoLayout.setBackgroundResource(17170444);
        this.mVideoLayout.addView(video);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1);
        lp.gravity = 17;
        this.mRootLayout.addView((View)this.mVideoLayout, (ViewGroup.LayoutParams)lp);
        this.mIsFullscreen = true;
    }

    public boolean isFullscreen() {
        return this.mIsFullscreen;
    }

    public void handleBackPress(Activity activity) {
        if (this.isFullscreen()) {
            this.hideVideoView();
        } else {
            this.loadUrl("");
            activity.finish();
        }
    }

    public void setAllowAutomaticNativeFullscreen(boolean allowAutomaticNativeFullscreen) {
        this.mAllowAutomaticNativeFullscreen = allowAutomaticNativeFullscreen;
    }

    public boolean isAutoPlaying() {
        return this.mAutoPlay;
    }

    public void setAutoPlay(boolean autoPlay) {
        this.mAutoPlay = autoPlay;
    }
}

