/*
 * Decompiled with CFR 0.152.
 */
package adfactory.player.android;

import adfactory.player.android.R;
import adfactory.player.android.interfaces.IVideoPlayer;
import android.content.Context;
import android.media.MediaPlayer;
import android.util.AttributeSet;
import android.widget.VideoView;
import java.util.ArrayList;
import java.util.List;

public class AdFactoryVideoView
extends VideoView
implements IVideoPlayer {
    int mVideoViewHeight;
    private final List<IVideoPlayer.IPlayerCallback> mVideoPlayerCallbacks = new ArrayList<IVideoPlayer.IPlayerCallback>(1);
    private PlaybackState mPlaybackState;

    public AdFactoryVideoView(Context context) {
        super(context);
        this.initialize();
    }

    public AdFactoryVideoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize();
    }

    private void initialize() {
        this.mVideoViewHeight = this.getResources().getDimensionPixelSize(R.dimen.adfactory_video_height);
        this.mPlaybackState = PlaybackState.STOPPED;
        super.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mediaPlayer) {
                AdFactoryVideoView.this.mPlaybackState = PlaybackState.STOPPED;
                for (IVideoPlayer.IPlayerCallback callback : AdFactoryVideoView.this.mVideoPlayerCallbacks) {
                    callback.onCompleted();
                }
            }
        });
        super.setOnErrorListener(new MediaPlayer.OnErrorListener(){

            public boolean onError(MediaPlayer mediaPlayer, int what, int extra) {
                AdFactoryVideoView.this.mPlaybackState = PlaybackState.STOPPED;
                for (IVideoPlayer.IPlayerCallback callback : AdFactoryVideoView.this.mVideoPlayerCallbacks) {
                    callback.onError(mediaPlayer, what, extra);
                }
                return true;
            }
        });
        super.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mediaPlayer) {
                for (IVideoPlayer.IPlayerCallback callback : AdFactoryVideoView.this.mVideoPlayerCallbacks) {
                    callback.onPrepare();
                }
            }
        });
    }

    public void start() {
        super.start();
        switch (this.mPlaybackState) {
            case STOPPED: {
                for (IVideoPlayer.IPlayerCallback callback : this.mVideoPlayerCallbacks) {
                    callback.onPlay();
                }
                break;
            }
            case PAUSED: {
                for (IVideoPlayer.IPlayerCallback callback : this.mVideoPlayerCallbacks) {
                    callback.onResume();
                }
                break;
            }
        }
        this.mPlaybackState = PlaybackState.PLAYING;
    }

    @Override
    public void play() {
        this.start();
    }

    @Override
    public void stopPlayback() {
        super.stopPlayback();
        this.mPlaybackState = PlaybackState.STOPPED;
    }

    @Override
    public void addPlayerCallback(IVideoPlayer.IPlayerCallback callback) {
        this.mVideoPlayerCallbacks.add(callback);
    }

    public void setOnCompletionListener(MediaPlayer.OnCompletionListener listener) {
        throw new UnsupportedOperationException();
    }

    public void setOnErrorListener(MediaPlayer.OnErrorListener listener) {
        throw new UnsupportedOperationException();
    }

    public void setOnPreparedListener(MediaPlayer.OnPreparedListener listener) {
        throw new UnsupportedOperationException();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = AdFactoryVideoView.getDefaultSize((int)0, (int)widthMeasureSpec);
        int height = AdFactoryVideoView.getDefaultSize((int)0, (int)heightMeasureSpec);
        this.setMeasuredDimension(width, height);
    }

    private static enum PlaybackState {
        STOPPED,
        PAUSED,
        PLAYING;

    }
}

