/*
 * Decompiled with CFR 0.152.
 */
package adfactory.player.android.Utils;

import adfactory.player.android.Models.VideoModel;
import android.os.AsyncTask;
import android.util.Log;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.json.JSONObject;

public class VideoRequestTask
extends AsyncTask<String, Void, VideoModel> {
    private onVideoReady mCallback;
    HttpURLConnection mConnection;
    String mVideoId;
    String mToken;

    public VideoRequestTask(String videoId, String token, onVideoReady callback) {
        Log.e((String)"Video Id", (String)videoId);
        this.mVideoId = videoId;
        this.mCallback = callback;
        this.mToken = token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VideoModel doInBackground(String ... strings) {
        try {
            String line;
            URL url = new URL(String.format("http://api.adfactory.me/v1/video/%s/", this.mVideoId));
            this.mConnection = (HttpURLConnection)url.openConnection();
            this.mConnection.setRequestMethod("GET");
            this.mConnection.setRequestProperty("app-source", "adfactory.player.android");
            this.mConnection.setRequestProperty("app-token", this.mToken);
            this.mConnection.connect();
            int responseCode = this.mConnection.getResponseCode();
            Log.e((String)"Status Code", (String)(responseCode + ""));
            BufferedReader br = new BufferedReader(new InputStreamReader(this.mConnection.getInputStream()));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
            }
            br.close();
            VideoModel videoModel = new VideoModel();
            JSONObject jsonObject = new JSONObject(sb.toString());
            Log.e((String)"Json", (String)sb.toString());
            if (jsonObject.has("title")) {
                videoModel.setTitle(jsonObject.getString("title"));
            }
            if (jsonObject.has("is_ready")) {
                videoModel.setReady(jsonObject.getBoolean("is_ready"));
            }
            if (jsonObject.has("dfp_tag")) {
                videoModel.setDfp(jsonObject.getString("dfp_tag"));
            }
            if (jsonObject.has("html")) {
                videoModel.setEmbed(jsonObject.getString("html"));
            }
            if (jsonObject.has("mp4_sd")) {
                videoModel.setVideoSd(jsonObject.getString("mp4_sd"));
            }
            if (jsonObject.has("mp4_hd") && jsonObject.getString("mp4_hd") != null) {
                videoModel.setHasHd(true);
                videoModel.setVideoHd(jsonObject.getString("mp4_hd"));
            }
            VideoModel videoModel2 = videoModel;
            return videoModel2;
        }
        catch (Exception e) {
            Log.e((String)"VideoRequestTask", (String)e.getMessage());
        }
        finally {
            if (this.mConnection != null) {
                this.mConnection.disconnect();
            }
        }
        return null;
    }

    protected void onPostExecute(VideoModel video) {
        super.onPostExecute((Object)video);
        if (this.mCallback != null) {
            if (video != null) {
                this.mCallback.onComplete(video);
            } else {
                this.mCallback.onError();
            }
        }
    }

    public static interface onVideoReady {
        public void onComplete(VideoModel var1);

        public void onError();
    }
}

