/*
 * Decompiled with CFR 0.152.
 */
package adfactory.player.android.Utils;

import adfactory.player.android.R;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.graphics.drawable.VectorDrawableCompat;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.text.TextUtils;
import android.util.TypedValue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
    public static StateListDrawable loadVectorDrawable(Context context, int resource) {
        VectorDrawableCompat normalState = VectorDrawableCompat.create((Resources)context.getResources(), (int)resource, (Resources.Theme)context.getTheme());
        Drawable pressedState = normalState.getConstantState().newDrawable().mutate();
        DrawableCompat.setTint((Drawable)pressedState, (int)ContextCompat.getColor((Context)context, (int)R.color.adfactory_controllers_focus_color));
        StateListDrawable stateList = new StateListDrawable();
        stateList.addState(new int[]{16842908, -16842919}, (Drawable)normalState);
        stateList.addState(new int[]{16842908, 16842919}, pressedState);
        stateList.addState(new int[]{-16842908, 16842919}, pressedState);
        stateList.addState(new int[0], (Drawable)normalState);
        return stateList;
    }

    public static String getApiKey(Context context) {
        try {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = ai.metaData;
            return bundle.getString("com.adfactory.key");
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String milliSecondsToTimer(long milliseconds) {
        String finalTimerString = "";
        String secondsString = "";
        int hours = (int)(milliseconds / 3600000L);
        int minutes = (int)(milliseconds % 3600000L) / 60000;
        int seconds = (int)(milliseconds % 3600000L % 60000L / 1000L);
        if (hours > 0) {
            finalTimerString = hours + ":";
        }
        secondsString = seconds < 10 ? "0" + seconds : "" + seconds;
        finalTimerString = finalTimerString + minutes + ":" + secondsString;
        return finalTimerString;
    }

    public static String extractVideoId(String videoUrl) {
        String videoId = "";
        if (videoUrl.endsWith("/")) {
            videoUrl = videoUrl.substring(0, videoUrl.length() - 1);
        }
        Uri uri = Uri.parse((String)videoUrl);
        videoId = uri.getLastPathSegment();
        return videoId;
    }

    public static String extractVideoUrl(String embed) {
        Pattern pattern = Pattern.compile("src=\"([^\"]+)\"");
        Matcher matcher = pattern.matcher(embed);
        String videoUrl = "";
        while (matcher.find()) {
            videoUrl = matcher.group(1);
        }
        if (!TextUtils.isEmpty((CharSequence)videoUrl)) {
            videoUrl = Utils.addMissingHttp(videoUrl);
        }
        return videoUrl;
    }

    public static String addMissingHttp(String url) {
        if (!url.startsWith("http")) {
            if (url.startsWith("//")) {
                return String.format("http:%s", url);
            }
            return String.format("http://%s", url);
        }
        return url;
    }

    public static int getThemeAccentColor(Context context) {
        int colorAttr = Build.VERSION.SDK_INT >= 21 ? 16843829 : context.getResources().getIdentifier("colorAccent", "attr", context.getPackageName());
        TypedValue outValue = new TypedValue();
        context.getTheme().resolveAttribute(colorAttr, outValue, true);
        return outValue.data;
    }
}

