/*
 * Decompiled with CFR 0.152.
 */
package adfactory.player.android;

import adfactory.player.android.AdFactory;
import adfactory.player.android.AdFactoryPlayer;
import adfactory.player.android.AdFactoryVideoView;
import adfactory.player.android.R;
import adfactory.player.android.Utils.Utils;
import adfactory.player.android.interfaces.IVideoPlayer;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.StateListDrawable;
import android.media.MediaPlayer;
import android.os.Handler;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.AppCompatImageButton;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;

public class AdFactoryPlayerControllers
extends RelativeLayout
implements View.OnClickListener {
    private boolean FORCE_VISIBILITY = true;
    private boolean DONT_FORCE_VISIBILITY = false;
    private boolean ENABLE_RUNNABLE = true;
    private boolean DISABLE_RUNNABLE = false;
    Runnable mControllersRunnable;
    Runnable mOnEverySecond;
    private boolean mIsCompleted = false;
    public static final String TAG = "adFactory";
    private AdFactoryVideoView mAdFactoryVideoView;
    AppCompatImageButton mPlayButton;
    AppCompatImageButton mFullScreenButton;
    StateListDrawable mPlayIcon;
    StateListDrawable mPauseIcon;
    StateListDrawable mFullScreenIcon;
    StateListDrawable mExitFullScreenIcon;
    StateListDrawable mReplayIcon;
    TextView mDurationTextView;
    TextView mCurrentPositionTextView;
    TextView mRetryButton;
    ProgressBar mProgressBar;
    SeekBar mSeekBar;
    AdFactory mAdFactory;
    AdFactoryPlayer.onVideoReady mCallback;
    View mControllersView;
    Boolean mOnSeekValueChanged = false;
    int mSeekBarColor;

    public AdFactoryPlayerControllers(Context context) {
        super(context);
        this.initView();
    }

    public AdFactoryPlayerControllers(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public void setup(AdFactoryVideoView videoView, AdFactory adFactory, int seekBarColor, AdFactoryPlayer.onVideoReady callback) {
        this.mAdFactoryVideoView = videoView;
        this.mAdFactory = adFactory;
        this.mCallback = callback;
        this.mSeekBarColor = seekBarColor;
        LayerDrawable layerDrawable = (LayerDrawable)this.mSeekBar.getProgressDrawable();
        ClipDrawable progressDrawable = (ClipDrawable)layerDrawable.findDrawableByLayerId(R.id.progressItem);
        progressDrawable.setColorFilter(this.mSeekBarColor, PorterDuff.Mode.SRC_IN);
    }

    public void displayErrorMessage(String errorMessage) {
        this.mIsCompleted = false;
        this.removeCallbacks(this.mControllersRunnable);
        this.setOnClickListener(null);
        this.mRetryButton.setVisibility(0);
        this.mRetryButton.setText((CharSequence)errorMessage);
        this.mRetryButton.setOnClickListener(null);
        this.hideSpinner();
        this.hideIcon(this.mPlayButton);
        this.mControllersView.setVisibility(8);
    }

    private void initView() {
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.adfactory_player_controllers, (ViewGroup)this);
        this.mPlayIcon = Utils.loadVectorDrawable(this.getContext(), R.drawable.adfactory_ico_play);
        this.mPauseIcon = Utils.loadVectorDrawable(this.getContext(), R.drawable.adfactory_ico_pause);
        this.mFullScreenIcon = Utils.loadVectorDrawable(this.getContext(), R.drawable.adfactory_ico_fullscreen);
        this.mExitFullScreenIcon = Utils.loadVectorDrawable(this.getContext(), R.drawable.adfactory_ico_fullscreen_exit);
        this.mReplayIcon = Utils.loadVectorDrawable(this.getContext(), R.drawable.adfactory_ico_replay);
        this.mRetryButton = (TextView)view.findViewById(R.id.error_text_view);
        this.mDurationTextView = (TextView)view.findViewById(R.id.adfactory_duration);
        this.mCurrentPositionTextView = (TextView)view.findViewById(R.id.adfactory_current_position);
        this.mSeekBar = (SeekBar)view.findViewById(R.id.adfactory_seek_bar);
        this.mProgressBar = (ProgressBar)view.findViewById(R.id.adfactory_progress_bar);
        this.mControllersView = view.findViewById(R.id.controllers);
        Typeface font = Typeface.createFromAsset((AssetManager)this.getContext().getAssets(), (String)this.getResources().getString(R.string.adfactory_default_font));
        this.mDurationTextView.setTypeface(font);
        this.mCurrentPositionTextView.setTypeface(font);
        this.mPlayButton = (AppCompatImageButton)view.findViewById(R.id.adfactory_play_button);
        this.mFullScreenButton = (AppCompatImageButton)view.findViewById(R.id.adfactory_ful_screen_button);
        this.showIcon(this.mPlayButton, (Drawable)this.mPlayIcon, this.DONT_FORCE_VISIBILITY);
        this.handleFullScreenButtonUI();
        this.showSpinner();
        this.mOnEverySecond = new Runnable(){

            @Override
            public void run() {
                if (AdFactoryPlayerControllers.this.mAdFactoryVideoView != null) {
                    if (AdFactoryPlayerControllers.this.mSeekBar != null) {
                        AdFactoryPlayerControllers.this.mSeekBar.setProgress(AdFactoryPlayerControllers.this.mAdFactoryVideoView.getCurrentPosition());
                    }
                    if (AdFactoryPlayerControllers.this.mAdFactoryVideoView.isPlaying()) {
                        AdFactoryPlayerControllers.this.mCurrentPositionTextView.setText((CharSequence)Utils.milliSecondsToTimer(AdFactoryPlayerControllers.this.mAdFactoryVideoView.getCurrentPosition()));
                        AdFactoryPlayerControllers.this.mSeekBar.postDelayed(AdFactoryPlayerControllers.this.mOnEverySecond, 1000L);
                    }
                }
                if (AdFactoryPlayerControllers.this.mOnSeekValueChanged.booleanValue()) {
                    AdFactoryPlayerControllers.this.hideSpinner();
                    AdFactoryPlayerControllers.this.mOnSeekValueChanged = false;
                    AdFactoryPlayerControllers.this.showIcon(AdFactoryPlayerControllers.this.mPlayButton, (Drawable)AdFactoryPlayerControllers.this.mPauseIcon, AdFactoryPlayerControllers.this.FORCE_VISIBILITY);
                }
            }
        };
        this.mControllersRunnable = new Runnable(){

            @Override
            public void run() {
                AdFactoryPlayerControllers.this.hideControllers(AdFactoryPlayerControllers.this.DISABLE_RUNNABLE);
            }
        };
        this.mSeekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                if (fromUser && AdFactoryPlayerControllers.this.mAdFactoryVideoView != null) {
                    AdFactoryPlayerControllers.this.mAdFactoryVideoView.seekTo(progress);
                    AdFactoryPlayerControllers.this.mOnSeekValueChanged = true;
                    AdFactoryPlayerControllers.this.removeCallbacks(AdFactoryPlayerControllers.this.mControllersRunnable);
                    AdFactoryPlayerControllers.this.postDelayed(AdFactoryPlayerControllers.this.mControllersRunnable, 1500L);
                    AdFactoryPlayerControllers.this.showSpinner();
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });
        this.setOnClickListener(this);
        this.mPlayButton.setOnClickListener((View.OnClickListener)this);
        this.mFullScreenButton.setOnClickListener((View.OnClickListener)this);
        this.mRetryButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AdFactoryPlayerControllers.this.mIsCompleted = false;
                AdFactoryPlayerControllers.this.mAdFactory.resumeContentAfterAdPlayback();
                AdFactoryPlayerControllers.this.mAdFactory.play();
                AdFactoryPlayerControllers.this.setOnClickListener(AdFactoryPlayerControllers.this);
                AdFactoryPlayerControllers.this.mRetryButton.setVisibility(8);
                AdFactoryPlayerControllers.this.showSpinner();
            }
        });
    }

    private void showIcon(final AppCompatImageButton button, final Drawable drawable2, final boolean forceVisibility) {
        button.clearAnimation();
        this.hideSpinner();
        AlphaAnimation fadeOut = new AlphaAnimation(button.getAlpha(), 0.0f);
        fadeOut.setInterpolator((Interpolator)new DecelerateInterpolator());
        fadeOut.setDuration(100L);
        fadeOut.setFillAfter(true);
        fadeOut.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                button.setImageDrawable(drawable2);
                if (forceVisibility && button.getVisibility() != 0) {
                    button.setVisibility(0);
                }
                button.clearAnimation();
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        button.startAnimation((Animation)fadeOut);
    }

    private void hideIcon(AppCompatImageButton button) {
        if (button.getVisibility() == 0) {
            button.setVisibility(8);
        }
    }

    private void showIcon(final AppCompatImageButton button, final Drawable drawable2) {
        button.clearAnimation();
        AlphaAnimation fadeOut = new AlphaAnimation(1.0f, 0.0f);
        fadeOut.setInterpolator((Interpolator)new DecelerateInterpolator());
        fadeOut.setDuration(100L);
        fadeOut.setFillAfter(true);
        fadeOut.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                button.setImageDrawable(drawable2);
                if (button.getVisibility() != 0) {
                    button.setVisibility(0);
                }
                button.clearAnimation();
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        button.startAnimation((Animation)fadeOut);
    }

    public void initialize() {
        this.setFocusable(true);
        this.showControllers(this.ENABLE_RUNNABLE);
        this.mAdFactoryVideoView.addPlayerCallback(new IVideoPlayer.IPlayerCallback(){

            @Override
            public void onPlay() {
                Log.e((String)"event", (String)"onPlay");
                AdFactoryPlayerControllers.this.mIsCompleted = false;
                AdFactoryPlayerControllers.this.hideSpinner();
                AdFactoryPlayerControllers.this.showIcon(AdFactoryPlayerControllers.this.mPlayButton, (Drawable)AdFactoryPlayerControllers.this.mPauseIcon, AdFactoryPlayerControllers.this.FORCE_VISIBILITY);
                if (!AdFactoryPlayerControllers.this.mAdFactory.getIsAdDisplayed() && AdFactoryPlayerControllers.this.mCallback != null) {
                    AdFactoryPlayerControllers.this.mCallback.onPlay();
                }
            }

            @Override
            public void onCompleted() {
                Log.e((String)"event", (String)"onCompleted");
                if (!AdFactoryPlayerControllers.this.mAdFactory.getIsAdDisplayed()) {
                    AdFactoryPlayerControllers.this.mIsCompleted = true;
                    AdFactoryPlayerControllers.this.hideSpinner();
                    AdFactoryPlayerControllers.this.showIcon(AdFactoryPlayerControllers.this.mPlayButton, (Drawable)AdFactoryPlayerControllers.this.mReplayIcon, AdFactoryPlayerControllers.this.DONT_FORCE_VISIBILITY);
                    AdFactoryPlayerControllers.this.removeCallbacks(AdFactoryPlayerControllers.this.mControllersRunnable);
                    AdFactoryPlayerControllers.this.showControllers(AdFactoryPlayerControllers.this.DISABLE_RUNNABLE);
                    AdFactoryPlayerControllers.this.mCurrentPositionTextView.setText((CharSequence)AdFactoryPlayerControllers.this.getContext().getString(R.string.adfactory_controllers_start_time));
                    AdFactoryPlayerControllers.this.mSeekBar.setEnabled(false);
                    if (AdFactoryPlayerControllers.this.mCallback != null) {
                        AdFactoryPlayerControllers.this.mCallback.onComplete();
                    }
                }
                AdFactoryPlayerControllers.this.hideSpinner();
            }

            @Override
            public void onError(MediaPlayer mp, int what, int extra) {
                Log.e((String)"Error", (String)("Error " + what + " - " + extra));
                if (!AdFactoryPlayerControllers.this.mAdFactory.getIsAdDisplayed()) {
                    if (!AdFactoryPlayerControllers.this.mIsCompleted) {
                        AdFactoryPlayerControllers.this.showControllers(AdFactoryPlayerControllers.this.DISABLE_RUNNABLE);
                        AdFactoryPlayerControllers.this.mRetryButton.setVisibility(0);
                        AdFactoryPlayerControllers.this.setOnClickListener(null);
                        AdFactoryPlayerControllers.this.hideSpinner();
                    }
                    if (AdFactoryPlayerControllers.this.mCallback != null) {
                        AdFactoryPlayerControllers.this.mCallback.onError();
                    }
                    AdFactoryPlayerControllers.this.hideIcon(AdFactoryPlayerControllers.this.mPlayButton);
                    AdFactoryPlayerControllers.this.hideSpinner();
                } else {
                    AdFactoryPlayerControllers.this.mAdFactoryVideoView.setVideoURI(null);
                }
            }

            @Override
            public void onPause() {
                AdFactoryPlayerControllers.this.hideSpinner();
                AdFactoryPlayerControllers.this.showIcon(AdFactoryPlayerControllers.this.mPlayButton, (Drawable)AdFactoryPlayerControllers.this.mPlayIcon, AdFactoryPlayerControllers.this.FORCE_VISIBILITY);
                if (!AdFactoryPlayerControllers.this.mAdFactory.getIsAdDisplayed() && AdFactoryPlayerControllers.this.mCallback != null) {
                    AdFactoryPlayerControllers.this.mCallback.onPause();
                }
            }

            @Override
            public void onResume() {
                if (AdFactoryPlayerControllers.this.mRetryButton.getVisibility() == 0) {
                    AdFactoryPlayerControllers.this.mRetryButton.setVisibility(8);
                }
                if (!AdFactoryPlayerControllers.this.mSeekBar.isEnabled()) {
                    AdFactoryPlayerControllers.this.mSeekBar.setEnabled(true);
                }
                if (!AdFactoryPlayerControllers.this.mAdFactory.getIsAdDisplayed() && AdFactoryPlayerControllers.this.mCallback != null) {
                    AdFactoryPlayerControllers.this.mCallback.onResume();
                }
                AdFactoryPlayerControllers.this.hideSpinner();
            }

            @Override
            public void onPrepare() {
                if (!AdFactoryPlayerControllers.this.mAdFactory.getIsAdDisplayed()) {
                    AdFactoryPlayerControllers.this.mSeekBar.setMax(AdFactoryPlayerControllers.this.mAdFactoryVideoView.getDuration());
                    AdFactoryPlayerControllers.this.mSeekBar.postDelayed(AdFactoryPlayerControllers.this.mOnEverySecond, 100L);
                    AdFactoryPlayerControllers.this.mDurationTextView.setText((CharSequence)Utils.milliSecondsToTimer(AdFactoryPlayerControllers.this.mAdFactoryVideoView.getDuration()));
                    AdFactoryPlayerControllers.this.hideControllers(AdFactoryPlayerControllers.this.ENABLE_RUNNABLE);
                }
                AdFactoryPlayerControllers.this.showIcon(AdFactoryPlayerControllers.this.mPlayButton, (Drawable)AdFactoryPlayerControllers.this.mPauseIcon);
                AdFactoryPlayerControllers.this.mRetryButton.setVisibility(8);
                AdFactoryPlayerControllers.this.setOnClickListener(AdFactoryPlayerControllers.this);
                AdFactoryPlayerControllers.this.hideSpinner();
            }
        });
    }

    public void onClick(View view) {
        if (view.getId() != this.getId() && this.mControllersView.getAlpha() == 0.0f) {
            this.showControllers(this.ENABLE_RUNNABLE);
            return;
        }
        if (view.getId() == this.mPlayButton.getId()) {
            if (this.mAdFactoryVideoView != null) {
                if (this.mAdFactoryVideoView.isPlaying()) {
                    this.removeCallbacks(this.mOnEverySecond);
                    this.showIcon(this.mPlayButton, (Drawable)this.mPlayIcon);
                    this.mAdFactoryVideoView.pause();
                    this.removeCallbacks(this.mControllersRunnable);
                } else {
                    if (!this.mIsCompleted) {
                        this.setOnClickListener(this);
                        this.mSeekBar.postDelayed(this.mOnEverySecond, 100L);
                        this.mAdFactoryVideoView.start();
                    } else {
                        this.showSpinner();
                        this.mIsCompleted = false;
                        this.removeCallbacks(this.mControllersRunnable);
                        this.mAdFactory.resumeContentAfterAdPlayback();
                        this.mSeekBar.setProgress(0);
                        this.mAdFactory.play();
                    }
                    this.hideControllers(this.DISABLE_RUNNABLE);
                    this.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            AdFactoryPlayerControllers.this.showIcon(AdFactoryPlayerControllers.this.mPlayButton, (Drawable)AdFactoryPlayerControllers.this.mPauseIcon, AdFactoryPlayerControllers.this.FORCE_VISIBILITY);
                        }
                    }, 500L);
                }
            }
        } else if (view.getId() == this.mFullScreenButton.getId()) {
            int orientation = this.getResources().getConfiguration().orientation;
            boolean fullscreen = orientation == 2;
            final AppCompatActivity activity = (AppCompatActivity)this.getContext();
            if (fullscreen) {
                activity.setRequestedOrientation(7);
            } else {
                activity.setRequestedOrientation(6);
            }
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    activity.setRequestedOrientation(4);
                }
            }, 1500L);
        } else if (view.getId() == this.getId()) {
            Log.d((String)TAG, (String)"Controllers Clicked");
            if (!this.mIsCompleted) {
                if (this.mControllersView.getAlpha() > 0.0f) {
                    this.hideControllers(this.ENABLE_RUNNABLE);
                } else {
                    this.showControllers(this.ENABLE_RUNNABLE);
                }
            }
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.handleFullScreenButtonUI();
    }

    private void handleFullScreenButtonUI() {
        boolean fullscreen;
        int orientation = this.getResources().getConfiguration().orientation;
        boolean bl = fullscreen = orientation == 2;
        if (fullscreen) {
            this.showIcon(this.mFullScreenButton, (Drawable)this.mExitFullScreenIcon, this.DONT_FORCE_VISIBILITY);
        } else {
            this.showIcon(this.mFullScreenButton, (Drawable)this.mFullScreenIcon, this.DONT_FORCE_VISIBILITY);
        }
    }

    private void showControllers(boolean runnable) {
        if (this.mControllersView.getAlpha() == 0.0f) {
            float from = 0.0f;
            float to = 1.0f;
            int duration = 500;
            this.runAlphaAnimation(this.mControllersView, from, to, duration);
        }
        if (runnable == this.ENABLE_RUNNABLE) {
            this.postDelayed(this.mControllersRunnable, 1500L);
        }
        this.mSeekBar.setEnabled(true);
    }

    private void hideControllers(boolean runnable) {
        float from = 1.0f;
        float to = 0.0f;
        int duration = 200;
        if (this.mControllersView.getAlpha() > 0.0f) {
            this.runAlphaAnimation(this.mControllersView, from, to, duration);
        }
        if (runnable == this.ENABLE_RUNNABLE) {
            this.removeCallbacks(this.mControllersRunnable);
        }
        this.mSeekBar.setEnabled(false);
    }

    private void showSpinner() {
        this.mProgressBar.setVisibility(0);
        if (this.mPlayButton.getVisibility() == 0) {
            this.mPlayButton.setVisibility(8);
        }
    }

    private void hideSpinner() {
        if (this.mProgressBar.getVisibility() == 0) {
            this.mProgressBar.setVisibility(8);
        }
    }

    private void runAlphaAnimation(View view, float from, float to, int duration) {
        ObjectAnimator anim = ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{from, to});
        anim.setDuration((long)duration);
        anim.start();
    }
}

