package adfactory.player.android;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.StateListDrawable;
import android.media.MediaPlayer;
import android.os.Handler;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.AppCompatImageButton;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;

import adfactory.player.android.Utils.Utils;
import adfactory.player.android.interfaces.IVideoPlayer;

/**
 * Created by medyo on 8/24/16.
 */
public class AdFactoryPlayerControllers extends RelativeLayout implements View.OnClickListener {

    private boolean FORCE_VISIBILITY = true;
    private boolean DONT_FORCE_VISIBILITY = false;
    private boolean ENABLE_RUNNABLE = true;
    private boolean DISABLE_RUNNABLE = false;

    Runnable mControllersRunnable, mOnEverySecond;
    private boolean mIsCompleted = false;
    public static final String TAG = "adFactory";
    private AdFactoryVideoView mAdFactoryVideoView;
    AppCompatImageButton mPlayButton, mFullScreenButton;
    StateListDrawable mPlayIcon, mPauseIcon, mFullScreenIcon, mExitFullScreenIcon, mReplayIcon;
    TextView mDurationTextView, mCurrentPositionTextView, mRetryButton;
    ProgressBar mProgressBar;
    SeekBar mSeekBar;
    AdFactory mAdFactory;
    AdFactoryPlayer.onVideoReady mCallback;
    View mControllersView;
    Boolean mOnSeekValueChanged = false;
    int mSeekBarColor;

    public AdFactoryPlayerControllers(Context context) {
        super(context);
        initView();
    }

    public AdFactoryPlayerControllers(Context context, AttributeSet attrs) {
        super(context, attrs);
        initView();
    }

    public void setup(AdFactoryVideoView videoView, AdFactory adFactory, int seekBarColor, AdFactoryPlayer.onVideoReady callback){
        this.mAdFactoryVideoView = videoView;
        this.mAdFactory = adFactory;
        this.mCallback = callback;
        this.mSeekBarColor = seekBarColor;


        LayerDrawable layerDrawable = (LayerDrawable) mSeekBar.getProgressDrawable();
        ClipDrawable progressDrawable = (ClipDrawable) layerDrawable.findDrawableByLayerId(R.id.progressItem);
        progressDrawable.setColorFilter(mSeekBarColor, PorterDuff.Mode.SRC_IN);
    }

    public void displayErrorMessage(String errorMessage){
        mIsCompleted = false;
        removeCallbacks(mControllersRunnable);
        setOnClickListener(null);
        mRetryButton.setVisibility(VISIBLE);
        mRetryButton.setText(errorMessage);
        mRetryButton.setOnClickListener(null);
        hideSpinner();
        hideIcon(mPlayButton);
        mControllersView.setVisibility(GONE);
    }
    private void initView() {
        View view = LayoutInflater.from(getContext()).inflate(R.layout.adfactory_player_controllers, this);

        mPlayIcon = Utils.loadVectorDrawable(getContext(), R.drawable.adfactory_ico_play);
        mPauseIcon = Utils.loadVectorDrawable(getContext(), R.drawable.adfactory_ico_pause);
        mFullScreenIcon = Utils.loadVectorDrawable(getContext(), R.drawable.adfactory_ico_fullscreen);
        mExitFullScreenIcon = Utils.loadVectorDrawable(getContext(), R.drawable.adfactory_ico_fullscreen_exit);
        mReplayIcon = Utils.loadVectorDrawable(getContext(), R.drawable.adfactory_ico_replay);

        mRetryButton = (TextView) view.findViewById(R.id.error_text_view);

        mDurationTextView = (TextView) view.findViewById(R.id.adfactory_duration);
        mCurrentPositionTextView = (TextView) view.findViewById(R.id.adfactory_current_position);

        mSeekBar = (SeekBar) view.findViewById(R.id.adfactory_seek_bar);

        mProgressBar = (ProgressBar) view.findViewById(R.id.adfactory_progress_bar);
        mControllersView = view.findViewById(R.id.controllers);

        Typeface font = Typeface.createFromAsset(getContext().getAssets(), getResources().getString(R.string.adfactory_default_font));
        mDurationTextView.setTypeface(font);
        mCurrentPositionTextView.setTypeface(font);

        mPlayButton = (AppCompatImageButton) view.findViewById(R.id.adfactory_play_button);
        mFullScreenButton = (AppCompatImageButton) view.findViewById(R.id.adfactory_ful_screen_button);

        showIcon(mPlayButton, mPlayIcon, DONT_FORCE_VISIBILITY);
        handleFullScreenButtonUI();
        showSpinner();

        mOnEverySecond = new Runnable() {

            @Override
            public void run() {

                if (mAdFactoryVideoView != null) {

                    if(mSeekBar != null) {
                        mSeekBar.setProgress(mAdFactoryVideoView.getCurrentPosition());
                    }

                    if(mAdFactoryVideoView.isPlaying()) {
                        mCurrentPositionTextView.setText(Utils.milliSecondsToTimer(mAdFactoryVideoView.getCurrentPosition()));
                        mSeekBar.postDelayed(mOnEverySecond, 1000);
                    }
                }


                if (mOnSeekValueChanged){
                    hideSpinner();
                    mOnSeekValueChanged = false;
                    showIcon(mPlayButton, mPauseIcon, FORCE_VISIBILITY);
                }

            }
        };

        mControllersRunnable = new Runnable() {
            public void run() {
                hideControllers(DISABLE_RUNNABLE);
            }
        };

        mSeekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            @Override
            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                if(fromUser && mAdFactoryVideoView != null) {
                    mAdFactoryVideoView.seekTo(progress);
                    mOnSeekValueChanged = true;
                    removeCallbacks(mControllersRunnable);
                    postDelayed(mControllersRunnable, 1500);
                    showSpinner();
                }
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {

            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {

            }
        });

        setOnClickListener(this);
        mPlayButton.setOnClickListener(this);
        mFullScreenButton.setOnClickListener(this);
        mRetryButton.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View view) {
                mIsCompleted = false;
                mAdFactory.resumeContentAfterAdPlayback();
                mAdFactory.play();
                setOnClickListener(AdFactoryPlayerControllers.this);
                mRetryButton.setVisibility(GONE);
                showSpinner();
            }
        });

    }

    private void showIcon(final AppCompatImageButton button, final Drawable drawable, final boolean forceVisibility){

        button.clearAnimation();

        hideSpinner();

        Animation fadeOut = new AlphaAnimation(button.getAlpha(), 0);
        fadeOut.setInterpolator(new DecelerateInterpolator());
        fadeOut.setDuration(100);
        fadeOut.setFillAfter(true);
        fadeOut.setAnimationListener(new Animation.AnimationListener() {
            @Override
            public void onAnimationStart(Animation animation) {

            }

            @Override
            public void onAnimationEnd(Animation animation) {
                button.setImageDrawable(drawable);

                if (forceVisibility && button.getVisibility() != VISIBLE){
                    button.setVisibility(VISIBLE);
                }

                button.clearAnimation();
            }

            @Override
            public void onAnimationRepeat(Animation animation) {

            }
        });

        button.startAnimation(fadeOut);

    }

    private void hideIcon(AppCompatImageButton button) {
        if (button.getVisibility() == VISIBLE){
            button.setVisibility(GONE);
        }
    }

    private void showIcon(final AppCompatImageButton button, final Drawable drawable){
        button.clearAnimation();

        Animation fadeOut = new AlphaAnimation(1, 0);
        fadeOut.setInterpolator(new DecelerateInterpolator());
        fadeOut.setDuration(100);
        fadeOut.setFillAfter(true);
        fadeOut.setAnimationListener(new Animation.AnimationListener() {
            @Override
            public void onAnimationStart(Animation animation) {

            }

            @Override
            public void onAnimationEnd(Animation animation) {
                button.setImageDrawable(drawable);

                if (button.getVisibility() != VISIBLE){
                    button.setVisibility(VISIBLE);
                }

                button.clearAnimation();
            }

            @Override
            public void onAnimationRepeat(Animation animation) {

            }
        });

        button.startAnimation(fadeOut);
    }

    public void initialize(){
        setFocusable(true);
        showControllers(ENABLE_RUNNABLE);

        mAdFactoryVideoView.addPlayerCallback(new IVideoPlayer.IPlayerCallback() {
            @Override
            public void onPlay() {
                Log.e("event", "onPlay");
                mIsCompleted = false;
                hideSpinner();
                showIcon(mPlayButton, mPauseIcon, FORCE_VISIBILITY);
                if (!mAdFactory.getIsAdDisplayed() && mCallback != null){
                    mCallback.onPlay();
                }
            }

            @Override
            public void onCompleted() {
                Log.e("event", "onCompleted");
                if (!mAdFactory.getIsAdDisplayed()){
                    mIsCompleted = true;
                    hideSpinner();
                    showIcon(mPlayButton, mReplayIcon, DONT_FORCE_VISIBILITY);
                    removeCallbacks(mControllersRunnable);
                    showControllers(DISABLE_RUNNABLE);
                    mCurrentPositionTextView.setText(getContext().getString(R.string.adfactory_controllers_start_time));
                    mSeekBar.setEnabled(false);

                    if (mCallback != null){
                        mCallback.onComplete();
                    }
                }

                hideSpinner();

            }

            @Override
            public void onError(MediaPlayer mp, int what, int extra) {
                Log.e("Error", "Error "+what+" - "+extra);
                if (!mAdFactory.getIsAdDisplayed()){
                    if (!mIsCompleted){
                        showControllers(DISABLE_RUNNABLE);
                        mRetryButton.setVisibility(VISIBLE);
                        setOnClickListener(null);
                        hideSpinner();
                    }

                    if (mCallback != null){
                        mCallback.onError();
                    }

                    hideIcon(mPlayButton);
                    hideSpinner();
                } else {
                    mAdFactoryVideoView.setVideoURI(null);
                    //mAdFactoryVideoView.setBackgroundColor(ContextCompat.getColor(getContext(), R.color.adfactory_default_background_color));
                }



            }

            @Override
            public void onPause() {
                hideSpinner();
                showIcon(mPlayButton, mPlayIcon, FORCE_VISIBILITY);
                if (!mAdFactory.getIsAdDisplayed() && mCallback != null){
                    mCallback.onPause();
                }
            }

            @Override
            public void onResume() {
                if (mRetryButton.getVisibility() == VISIBLE){
                    mRetryButton.setVisibility(GONE);
                }

                if (!mSeekBar.isEnabled()){
                    mSeekBar.setEnabled(true);
                }

                if (!mAdFactory.getIsAdDisplayed() && mCallback != null){
                    mCallback.onResume();
                }
                hideSpinner();

            }

            @Override
            public void onPrepare() {
                if (!mAdFactory.getIsAdDisplayed()){
                    mSeekBar.setMax(mAdFactoryVideoView.getDuration());
                    mSeekBar.postDelayed(mOnEverySecond, 100);
                    mDurationTextView.setText(Utils.milliSecondsToTimer(mAdFactoryVideoView.getDuration()));
                    hideControllers(ENABLE_RUNNABLE);
                }

                /*if (mAdFactoryVideoView.getBackground() != null){
                    mAdFactoryVideoView.setBackgroundResource(0);
                }*/
                showIcon(mPlayButton, mPauseIcon);
                mRetryButton.setVisibility(GONE);
                setOnClickListener(AdFactoryPlayerControllers.this);
                hideSpinner();
            }
        });
    }

    @Override
    public void onClick(View view) {

        if (view.getId() != getId() && mControllersView.getAlpha() == 0){
            showControllers(ENABLE_RUNNABLE);
            return;
        }


        if (view.getId() == mPlayButton.getId()){

            if (mAdFactoryVideoView != null){
                if (mAdFactoryVideoView.isPlaying()){

                    removeCallbacks(mOnEverySecond);
                    showIcon(mPlayButton, mPlayIcon);
                    mAdFactoryVideoView.pause();
                    removeCallbacks(mControllersRunnable);
                } else {
                    if (!mIsCompleted){
                        setOnClickListener(AdFactoryPlayerControllers.this);
                        mSeekBar.postDelayed(mOnEverySecond, 100);
                        mAdFactoryVideoView.start();
                    } else {
                        showSpinner();
                        mIsCompleted = false;
                        removeCallbacks(mControllersRunnable);
                        mAdFactory.resumeContentAfterAdPlayback();
                        mSeekBar.setProgress(0);
                        mAdFactory.play();
                    }
                    hideControllers(DISABLE_RUNNABLE);
                    postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            showIcon(mPlayButton, mPauseIcon, FORCE_VISIBILITY);
                        }
                    }, 500);

                }
            }

        } else if (view.getId() == mFullScreenButton.getId()){
            int orientation = getResources().getConfiguration().orientation;
            boolean fullscreen = (orientation == Configuration.ORIENTATION_LANDSCAPE);
            final AppCompatActivity activity = ((AppCompatActivity) getContext());
            if (fullscreen) {
                activity.setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR_PORTRAIT);
            } else {
                activity.setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR_LANDSCAPE);
            }

            new Handler().postDelayed(new Runnable() {
                public void run() {
                    activity.setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR);
                }
            }, 1500);

        } else if (view.getId() == getId()){
            Log.d(TAG, "Controllers Clicked");
            if (!mIsCompleted){
                if (mControllersView.getAlpha() > 0){
                    hideControllers(ENABLE_RUNNABLE);
                } else {
                    showControllers(ENABLE_RUNNABLE);
                }
            }

        }
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);

        handleFullScreenButtonUI();
    }

    private void handleFullScreenButtonUI() {
        int orientation = getResources().getConfiguration().orientation;
        boolean fullscreen = (orientation == Configuration.ORIENTATION_LANDSCAPE);

        if (fullscreen){
            showIcon(mFullScreenButton, mExitFullScreenIcon, DONT_FORCE_VISIBILITY);
        } else {
            showIcon(mFullScreenButton, mFullScreenIcon, DONT_FORCE_VISIBILITY);
        }
    }

    private void showControllers(boolean runnable){
        if (mControllersView.getAlpha() == 0){
            float from = 0f;
            float to = 1.0f;
            int duration = 500;

            runAlphaAnimation(mControllersView, from, to, duration);
        }

        if (runnable == ENABLE_RUNNABLE){
            postDelayed(mControllersRunnable, 1500);
        }
        mSeekBar.setEnabled(true);

    }

    private void hideControllers(boolean runnable){
        float from = 1.0f;
        float to = 0f;
        int duration = 200;


        if (mControllersView.getAlpha() > 0){
            runAlphaAnimation(mControllersView, from, to, duration);
        }

        if (runnable == ENABLE_RUNNABLE){
            removeCallbacks(mControllersRunnable);
        }
        mSeekBar.setEnabled(false);
    }

    private void showSpinner(){
        mProgressBar.setVisibility(VISIBLE);
        if (mPlayButton.getVisibility() == VISIBLE){
            mPlayButton.setVisibility(GONE);
        }
    }

    private void hideSpinner(){
        if (mProgressBar.getVisibility() == VISIBLE){
            mProgressBar.setVisibility(GONE);
        }
    }

    private void runAlphaAnimation(View view, float from, float to, int duration){
        ObjectAnimator anim = ObjectAnimator.ofFloat(view, "alpha",  from, to);
        anim.setDuration(duration);
        anim.start();
    }
}
