/*
 * Decompiled with CFR 0.152.
 */
package adfactory.player.android;

import adfactory.player.android.AdFactory;
import adfactory.player.android.AdFactoryPlayerControllers;
import adfactory.player.android.R;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.google.ads.interactivemedia.v3.api.AdDisplayContainer;
import com.google.ads.interactivemedia.v3.api.AdErrorEvent;
import com.google.ads.interactivemedia.v3.api.AdEvent;
import com.google.ads.interactivemedia.v3.api.AdsLoader;
import com.google.ads.interactivemedia.v3.api.AdsManager;
import com.google.ads.interactivemedia.v3.api.AdsManagerLoadedEvent;
import com.google.ads.interactivemedia.v3.api.AdsRequest;
import com.google.ads.interactivemedia.v3.api.ImaSdkFactory;

public class VideoLoader
implements AdsLoader.AdsLoadedListener,
AdErrorEvent.AdErrorListener,
AdEvent.AdEventListener,
AdFactory.OnContentCompleteListener,
AdFactory.OnContentPreparedListener {
    private static final String TAG = "adFactory";
    String mVideoUrl;
    String mDfpUrl;
    Context mContext;
    AdFactoryPlayerControllers mControllers;
    AdFactory mAdFactory;
    private AdsLoader mAdsLoader;
    private AdsManager mAdsManager;
    private ImaSdkFactory mSdkFactory;
    private AdDisplayContainer mAdDisplayContainer;

    public VideoLoader(Context context, AdFactory adFactory, AdFactoryPlayerControllers controllers, String dfpUrl) {
        Log.e((String)TAG, (String)"init AdFactory Player ...");
        this.mAdFactory = adFactory;
        this.mContext = context;
        this.mControllers = controllers;
        this.mDfpUrl = dfpUrl;
        this.init();
    }

    private void init() {
        if (TextUtils.isEmpty((CharSequence)this.mVideoUrl)) {
            Log.e((String)TAG, (String)this.mContext.getString(R.string.adfactory_exception_invalid_video_url));
        }
    }

    public void setup() {
        this.mAdFactory.initialize();
        this.mAdFactory.setOnContentCompleteListener(this);
        this.mAdFactory.setOnContentPreparedListener(this);
        this.mSdkFactory = ImaSdkFactory.getInstance();
        this.mAdsLoader = this.mSdkFactory.createAdsLoader(this.mContext);
        this.mAdsLoader.addAdErrorListener((AdErrorEvent.AdErrorListener)this);
        this.mAdsLoader.addAdsLoadedListener((AdsLoader.AdsLoadedListener)this);
    }

    public void onAdsManagerLoaded(AdsManagerLoadedEvent adsManagerLoadedEvent) {
        Log.d((String)TAG, (String)"onAdsManagerLoaded");
        this.mAdsManager = adsManagerLoadedEvent.getAdsManager();
        this.mAdsManager.addAdErrorListener((AdErrorEvent.AdErrorListener)this);
        this.mAdsManager.addAdEventListener((AdEvent.AdEventListener)this);
        this.mAdsManager.init();
    }

    public void onAdError(AdErrorEvent adErrorEvent) {
        Log.e((String)TAG, (String)("Ad Error: " + adErrorEvent.getError().getMessage()));
        this.mAdFactory.resumeContentAfterAdPlayback();
    }

    public void onAdEvent(AdEvent adEvent) {
        Log.e((String)TAG, (String)("Event: " + adEvent.getType()));
        switch (adEvent.getType()) {
            case LOADED: {
                this.mAdsManager.start();
                break;
            }
            case CONTENT_PAUSE_REQUESTED: {
                this.mAdFactory.pauseContentForAdPlayback();
                break;
            }
            case CONTENT_RESUME_REQUESTED: {
                this.mAdFactory.resumeContentAfterAdPlayback();
                break;
            }
            case ALL_ADS_COMPLETED: {
                if (this.mAdsManager == null) break;
                this.mAdsManager.destroy();
                this.mAdsManager = null;
                break;
            }
        }
    }

    private void requestAds() {
        this.requestAds(this.mDfpUrl);
    }

    private void requestAds(String adTagUrl) {
        Log.d((String)TAG, (String)"requestAds");
        this.mAdDisplayContainer = this.mSdkFactory.createAdDisplayContainer();
        this.mAdDisplayContainer.setPlayer(this.mAdFactory.getVideoAdPlayer());
        this.mAdDisplayContainer.setAdContainer(this.mAdFactory.getAdUiContainer());
        AdsRequest request = this.mSdkFactory.createAdsRequest();
        request.setAdTagUrl(adTagUrl);
        request.setAdDisplayContainer(this.mAdDisplayContainer);
        request.setContentProgressProvider(this.mAdFactory.getContentProgressProvider());
        this.mAdsLoader.requestAds(request);
    }

    public void play() {
        this.requestAds();
    }

    public void resume() {
        Log.d((String)TAG, (String)"resume");
        this.mAdFactory.restorePosition();
        if (this.mAdsManager != null && this.mAdFactory.getIsAdDisplayed()) {
            this.mAdsManager.resume();
        }
    }

    public void pause() {
        Log.d((String)TAG, (String)"pause");
        this.mAdFactory.savePosition();
        if (this.mAdsManager != null && this.mAdFactory.getIsAdDisplayed()) {
            this.mAdsManager.pause();
        }
    }

    @Override
    public void onContentComplete() {
        this.mAdsLoader.contentComplete();
    }

    @Override
    public void onContentPrepared() {
        Log.d((String)"VideoLoader", (String)"onContentPrepared");
    }
}

