/*
 * Decompiled with CFR 0.152.
 */
package adfactory.player.android;

import adfactory.player.android.AdFactory;
import adfactory.player.android.AdFactoryPlayerControllers;
import adfactory.player.android.AdFactoryVideoView;
import adfactory.player.android.Models.VideoModel;
import adfactory.player.android.R;
import adfactory.player.android.Utils.Html5WebVideoView;
import adfactory.player.android.Utils.Utils;
import adfactory.player.android.Utils.VideoRequestTask;
import adfactory.player.android.VideoLoader;
import android.content.Context;
import android.content.res.Configuration;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.view.Window;
import android.webkit.URLUtil;
import android.widget.RelativeLayout;
import android.widget.TextView;

public class AdFactoryPlayer
extends RelativeLayout {
    RelativeLayout mWrapper;
    TextView mTextError;
    AdFactoryVideoView mVideoView;
    View mRootView;
    VideoLoader mVideoLoader;
    int mVideoViewBackgroundColor;
    AdFactoryPlayerControllers mControllers;
    AdFactory mAdFactory;
    String mVideoUrl;
    String mVideoId;
    onVideoReady mCallback;
    Boolean mSetupReady = false;
    Html5WebVideoView mWebView;
    String mApiKey;
    int mSeekBarColor;
    VideoModel mVideoModel;

    public AdFactoryPlayer(Context context) {
        super(context);
        this.initView();
    }

    public AdFactoryPlayer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public void setUrl(String url) {
        this.mVideoUrl = url;
    }

    public void initView() {
        this.mRootView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.adfactory_player, (ViewGroup)this);
        this.mVideoViewBackgroundColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.adfactory_default_background_color);
        this.mWrapper = (RelativeLayout)this.mRootView.findViewById(R.id.wrapper);
        this.mWrapper.setBackgroundColor(this.mVideoViewBackgroundColor);
        this.mSeekBarColor = Utils.getThemeAccentColor(this.getContext());
        this.mTextError = (TextView)this.mRootView.findViewById(R.id.error_text_view);
        this.mApiKey = Utils.getApiKey(this.getContext());
        this.mSetupReady = !TextUtils.isEmpty((CharSequence)this.mApiKey);
        if (!this.mSetupReady.booleanValue()) {
            Log.e((String)"AdFactory", (String)"Please add <meta-data android:name=\"com.adfactory.key\"\n            android:value=\"Your Api Key\" /> To your manifest file");
            this.displayError(this.getContext().getResources().getString(R.string.adfactory_exception_missing_key));
        } else {
            this.mTextError.setVisibility(8);
        }
    }

    public void setCallback(onVideoReady callback) {
        this.mCallback = callback;
    }

    private void displayError(String error) {
        this.mTextError.setText((CharSequence)error);
        this.mTextError.setVisibility(0);
    }

    public void play(String embed) {
        this.mVideoUrl = embed;
        if (this.mSetupReady.booleanValue()) {
            if (this.mVideoModel != null) {
                return;
            }
            if (URLUtil.isHttpUrl((String)embed) || URLUtil.isHttpsUrl((String)embed)) {
                this.mVideoId = Utils.extractVideoId(embed);
            } else {
                this.mVideoUrl = Utils.extractVideoUrl(embed);
                Log.e((String)"Url", (String)this.mVideoUrl);
                this.mVideoId = Utils.extractVideoId(this.mVideoUrl);
                Log.e((String)"mVideoId", (String)this.mVideoId);
            }
            if (TextUtils.isEmpty((CharSequence)this.mVideoId)) {
                this.displayError(this.getResources().getString(R.string.adfactory_exception_video_not_found));
            } else {
                new VideoRequestTask(this.mVideoId, this.mApiKey, new VideoRequestTask.onVideoReady(){

                    @Override
                    public void onComplete(VideoModel video) {
                        AdFactoryPlayer.this.mVideoModel = video;
                        if (video.getReady().booleanValue()) {
                            ViewStub videoPlayerStub = (ViewStub)AdFactoryPlayer.this.mRootView.findViewById(R.id.stub_video_player);
                            videoPlayerStub.inflate();
                            AdFactoryPlayer.this.mVideoView = (AdFactoryVideoView)AdFactoryPlayer.this.mRootView.findViewById(R.id.adfactory_video_view);
                            AdFactoryPlayer.this.mControllers = (AdFactoryPlayerControllers)AdFactoryPlayer.this.mRootView.findViewById(R.id.adfactory_controllers);
                            AdFactoryPlayer.this.mAdFactory = new AdFactory(AdFactoryPlayer.this.mVideoView, (ViewGroup)AdFactoryPlayer.this.mWrapper, video.getVideoSd());
                            AdFactoryPlayer.this.mControllers.setup(AdFactoryPlayer.this.mVideoView, AdFactoryPlayer.this.mAdFactory, AdFactoryPlayer.this.mSeekBarColor, AdFactoryPlayer.this.mCallback);
                            AdFactoryPlayer.this.mControllers.initialize();
                            AdFactoryPlayer.this.mVideoLoader = new VideoLoader(AdFactoryPlayer.this.getContext(), AdFactoryPlayer.this.mAdFactory, AdFactoryPlayer.this.mControllers, video.getDfp());
                            AdFactoryPlayer.this.mVideoLoader.setup();
                            AdFactoryPlayer.this.mVideoLoader.play();
                        } else {
                            ViewStub videoWebViewStub = (ViewStub)AdFactoryPlayer.this.mRootView.findViewById(R.id.stub_video_web_view);
                            videoWebViewStub.inflate();
                            AdFactoryPlayer.this.mWebView = (Html5WebVideoView)AdFactoryPlayer.this.mRootView.findViewById(R.id.adfactory_webView);
                            AdFactoryPlayer.this.mWebView.setAutoPlay(true);
                            AdFactoryPlayer.this.mWebView.loadDataWithBaseURL("", video.getEmbed().replace("https", "http"), "text/html", "UTF-8", "");
                        }
                    }

                    @Override
                    public void onError() {
                        AdFactoryPlayer.this.displayError(AdFactoryPlayer.this.getResources().getString(R.string.adfactory_exception_video_not_found));
                    }
                }).execute(new String[0]);
            }
        }
    }

    public void resume() {
        if (this.mVideoLoader != null) {
            this.mVideoLoader.resume();
        }
    }

    public void pause() {
        if (this.mVideoLoader != null) {
            this.mVideoLoader.pause();
        }
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.handleOrientation();
    }

    protected void handleOrientation() {
        int orientation = this.getResources().getConfiguration().orientation;
        boolean fullscreen = orientation == 2;
        int videoHeight = this.getResources().getDimensionPixelSize(R.dimen.adfactory_video_height);
        if (fullscreen) {
            this.getWindow().setFlags(1024, 1024);
            this.getWindow().clearFlags(2048);
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mWrapper.getLayoutParams();
            params.width = -1;
            params.height = -1;
            this.mWrapper.setLayoutParams((ViewGroup.LayoutParams)params);
            if (this.mCallback != null) {
                this.mCallback.onOrientationChange(true);
            }
        } else {
            this.getWindow().clearFlags(1024);
            this.getWindow().addFlags(2048);
            RelativeLayout.LayoutParams videoItemParams = new RelativeLayout.LayoutParams(-1, videoHeight);
            this.mWrapper.setLayoutParams((ViewGroup.LayoutParams)videoItemParams);
            if (this.mCallback != null) {
                this.mCallback.onOrientationChange(false);
            }
        }
        this.getWindow().getDecorView().requestLayout();
    }

    private Window getWindow() {
        return ((AppCompatActivity)this.getContext()).getWindow();
    }

    public AdFactoryPlayerControllers getControllers() {
        return this.mControllers;
    }

    public void setSeekBarColor(int color2) {
        this.mSeekBarColor = color2;
    }

    public static interface onVideoReady {
        public void onPlay();

        public void onComplete();

        public void onError();

        public void onPause();

        public void onResume();

        public void onOrientationChange(boolean var1);
    }
}

