package adfactory.player.android.Utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.graphics.drawable.VectorDrawableCompat;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.text.TextUtils;
import android.util.TypedValue;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import adfactory.player.android.R;

/**
 * Created by medyo on 8/25/16.
 */
public class Utils {

    public static StateListDrawable loadVectorDrawable(Context context, int resource){
        Drawable normalState = VectorDrawableCompat.create(context.getResources(), resource, context.getTheme());
        Drawable pressedState = normalState.getConstantState().newDrawable().mutate();

        DrawableCompat.setTint(pressedState, ContextCompat.getColor(context, R.color.adfactory_controllers_focus_color));

        StateListDrawable stateList = new StateListDrawable();
        stateList.addState(new int[]{android.R.attr.state_focused, -android.R.attr.state_pressed}, normalState);
        stateList.addState(new int[]{android.R.attr.state_focused, android.R.attr.state_pressed}, pressedState);
        stateList.addState(new int[]{-android.R.attr.state_focused, android.R.attr.state_pressed}, pressedState);
        stateList.addState(new int[]{}, normalState);

        return stateList;

    }

    public static String getApiKey(Context context){
        try {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
            Bundle bundle = ai.metaData;
            return bundle.getString("com.adfactory.key");
        } catch (Exception e) {
            return "";
        }
    }
    public static String milliSecondsToTimer(long milliseconds) {
        String finalTimerString = "";
        String secondsString = "";

        // Convert total duration into time
        int hours = (int) (milliseconds / (1000 * 60 * 60));
        int minutes = (int) (milliseconds % (1000 * 60 * 60)) / (1000 * 60);
        int seconds = (int) ((milliseconds % (1000 * 60 * 60)) % (1000 * 60) / 1000);
        // Add hours if there
        if (hours > 0) {
            finalTimerString = hours + ":";
        }

        // Prepending 0 to seconds if it is one digit
        if (seconds < 10) {
            secondsString = "0" + seconds;
        } else {
            secondsString = "" + seconds;
        }

        finalTimerString = finalTimerString + minutes + ":" + secondsString;

        // return timer string
        return finalTimerString;
    }

    public static String extractVideoId(String videoUrl){
        String videoId = "";
        if (videoUrl.endsWith("/")) {
            videoUrl = videoUrl.substring(0, videoUrl.length() - 1);
        }
        Uri uri = Uri.parse(videoUrl);
        videoId = uri.getLastPathSegment();

        return videoId;
    }

    public static String extractVideoUrl(String embed){
        Pattern pattern = Pattern.compile("src=\"([^\"]+)\"");
        Matcher matcher = pattern.matcher(embed);
        String videoUrl="";
        while (matcher.find()) {
            videoUrl = matcher.group(1);
        }

        if (!TextUtils.isEmpty(videoUrl)){
            videoUrl = addMissingHttp(videoUrl);
        }


        return videoUrl;
    }

    public static String addMissingHttp(String url){

        if (!url.startsWith("http")){
            if (url.startsWith("//")){
                return String.format("http:%s", url);
            } else {
                return String.format("http://%s", url);
            }
        }

        return url;
    }

    public static int getThemeAccentColor(Context context) {
        int colorAttr;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            colorAttr = android.R.attr.colorAccent;
        } else {
            //Get colorAccent defined for AppCompat
            colorAttr = context.getResources().getIdentifier("colorAccent", "attr", context.getPackageName());
        }
        TypedValue outValue = new TypedValue();
        context.getTheme().resolveAttribute(colorAttr, outValue, true);
        return outValue.data;
    }
}
