/*
 * Decompiled with CFR 0.152.
 */
package com.universalvideoview;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import com.universalvideoview.OrientationDetector;
import com.universalvideoview.R;
import com.universalvideoview.UniversalMediaController;
import java.io.IOException;
import java.util.Map;

public class UniversalVideoView
extends SurfaceView
implements UniversalMediaController.MediaPlayerControl,
OrientationDetector.OrientationChangeListener {
    private String TAG = "UniversalVideoView";
    private Uri mUri;
    private static final int STATE_ERROR = -1;
    private static final int STATE_IDLE = 0;
    private static final int STATE_PREPARING = 1;
    private static final int STATE_PREPARED = 2;
    private static final int STATE_PLAYING = 3;
    private static final int STATE_PAUSED = 4;
    private static final int STATE_PLAYBACK_COMPLETED = 5;
    private int mCurrentState = 0;
    private int mTargetState = 0;
    private SurfaceHolder mSurfaceHolder = null;
    private MediaPlayer mMediaPlayer = null;
    private int mAudioSession;
    private int mVideoWidth;
    private int mVideoHeight;
    private int mSurfaceWidth;
    private int mSurfaceHeight;
    private UniversalMediaController mMediaController;
    private MediaPlayer.OnCompletionListener mOnCompletionListener;
    private MediaPlayer.OnPreparedListener mOnPreparedListener;
    private int mCurrentBufferPercentage;
    private MediaPlayer.OnErrorListener mOnErrorListener;
    private MediaPlayer.OnInfoListener mOnInfoListener;
    private int mSeekWhenPrepared;
    private boolean mCanPause;
    private boolean mCanSeekBack;
    private boolean mCanSeekForward;
    private boolean mPreparedBeforeStart;
    private Context mContext;
    private boolean mFitXY = false;
    private boolean mAutoRotation = false;
    private int mVideoViewLayoutWidth = 0;
    private int mVideoViewLayoutHeight = 0;
    private OrientationDetector mOrientationDetector;
    private VideoViewCallback videoViewCallback;
    MediaPlayer.OnVideoSizeChangedListener mSizeChangedListener = new MediaPlayer.OnVideoSizeChangedListener(){

        public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
            UniversalVideoView.this.mVideoWidth = mp.getVideoWidth();
            UniversalVideoView.this.mVideoHeight = mp.getVideoHeight();
            Log.d((String)UniversalVideoView.this.TAG, (String)String.format("onVideoSizeChanged width=%d,height=%d", UniversalVideoView.this.mVideoWidth, UniversalVideoView.this.mVideoHeight));
            if (UniversalVideoView.this.mVideoWidth != 0 && UniversalVideoView.this.mVideoHeight != 0) {
                UniversalVideoView.this.getHolder().setFixedSize(UniversalVideoView.this.mVideoWidth, UniversalVideoView.this.mVideoHeight);
                UniversalVideoView.this.requestLayout();
            }
        }
    };
    MediaPlayer.OnPreparedListener mPreparedListener = new MediaPlayer.OnPreparedListener(){

        public void onPrepared(MediaPlayer mp) {
            UniversalVideoView.this.mCurrentState = 2;
            UniversalVideoView.this.mCanPause = (UniversalVideoView.this.mCanSeekBack = (UniversalVideoView.this.mCanSeekForward = true));
            UniversalVideoView.this.mPreparedBeforeStart = true;
            if (UniversalVideoView.this.mMediaController != null) {
                UniversalVideoView.this.mMediaController.hideLoading();
            }
            if (UniversalVideoView.this.mOnPreparedListener != null) {
                UniversalVideoView.this.mOnPreparedListener.onPrepared(UniversalVideoView.this.mMediaPlayer);
            }
            if (UniversalVideoView.this.mMediaController != null) {
                UniversalVideoView.this.mMediaController.setEnabled(true);
            }
            UniversalVideoView.this.mVideoWidth = mp.getVideoWidth();
            UniversalVideoView.this.mVideoHeight = mp.getVideoHeight();
            int seekToPosition = UniversalVideoView.this.mSeekWhenPrepared;
            if (seekToPosition != 0) {
                UniversalVideoView.this.seekTo(seekToPosition);
            }
            if (UniversalVideoView.this.mVideoWidth != 0 && UniversalVideoView.this.mVideoHeight != 0) {
                UniversalVideoView.this.getHolder().setFixedSize(UniversalVideoView.this.mVideoWidth, UniversalVideoView.this.mVideoHeight);
                if (UniversalVideoView.this.mSurfaceWidth == UniversalVideoView.this.mVideoWidth && UniversalVideoView.this.mSurfaceHeight == UniversalVideoView.this.mVideoHeight) {
                    if (UniversalVideoView.this.mTargetState == 3) {
                        UniversalVideoView.this.start();
                        if (UniversalVideoView.this.mMediaController != null) {
                            UniversalVideoView.this.mMediaController.show();
                        }
                    } else if (!(UniversalVideoView.this.isPlaying() || seekToPosition == 0 && UniversalVideoView.this.getCurrentPosition() <= 0 || UniversalVideoView.this.mMediaController == null)) {
                        UniversalVideoView.this.mMediaController.show(0);
                    }
                }
            } else if (UniversalVideoView.this.mTargetState == 3) {
                UniversalVideoView.this.start();
            }
        }
    };
    private MediaPlayer.OnCompletionListener mCompletionListener = new MediaPlayer.OnCompletionListener(){

        public void onCompletion(MediaPlayer mp) {
            UniversalVideoView.this.mCurrentState = 5;
            UniversalVideoView.this.mTargetState = 5;
            if (UniversalVideoView.this.mMediaController != null) {
                boolean a = UniversalVideoView.this.mMediaPlayer.isPlaying();
                int b = UniversalVideoView.this.mCurrentState;
                UniversalVideoView.this.mMediaController.showComplete();
                Log.d((String)UniversalVideoView.this.TAG, (String)String.format("a=%s,b=%d", a, b));
            }
            if (UniversalVideoView.this.mOnCompletionListener != null) {
                UniversalVideoView.this.mOnCompletionListener.onCompletion(UniversalVideoView.this.mMediaPlayer);
            }
        }
    };
    private MediaPlayer.OnInfoListener mInfoListener = new MediaPlayer.OnInfoListener(){

        public boolean onInfo(MediaPlayer mp, int what, int extra) {
            boolean handled = false;
            switch (what) {
                case 701: {
                    Log.d((String)UniversalVideoView.this.TAG, (String)"onInfo MediaPlayer.MEDIA_INFO_BUFFERING_START");
                    if (UniversalVideoView.this.videoViewCallback != null) {
                        UniversalVideoView.this.videoViewCallback.onBufferingStart(UniversalVideoView.this.mMediaPlayer);
                    }
                    if (UniversalVideoView.this.mMediaController != null) {
                        UniversalVideoView.this.mMediaController.showLoading();
                    }
                    handled = true;
                    break;
                }
                case 702: {
                    Log.d((String)UniversalVideoView.this.TAG, (String)"onInfo MediaPlayer.MEDIA_INFO_BUFFERING_END");
                    if (UniversalVideoView.this.videoViewCallback != null) {
                        UniversalVideoView.this.videoViewCallback.onBufferingEnd(UniversalVideoView.this.mMediaPlayer);
                    }
                    if (UniversalVideoView.this.mMediaController != null) {
                        UniversalVideoView.this.mMediaController.hideLoading();
                    }
                    handled = true;
                }
            }
            if (UniversalVideoView.this.mOnInfoListener != null) {
                return UniversalVideoView.this.mOnInfoListener.onInfo(mp, what, extra) || handled;
            }
            return handled;
        }
    };
    private MediaPlayer.OnErrorListener mErrorListener = new MediaPlayer.OnErrorListener(){

        public boolean onError(MediaPlayer mp, int framework_err, int impl_err) {
            Log.d((String)UniversalVideoView.this.TAG, (String)("Error: " + framework_err + "," + impl_err));
            UniversalVideoView.this.mCurrentState = -1;
            UniversalVideoView.this.mTargetState = -1;
            if (UniversalVideoView.this.mMediaController != null) {
                UniversalVideoView.this.mMediaController.showError();
            }
            if (UniversalVideoView.this.mOnErrorListener != null && UniversalVideoView.this.mOnErrorListener.onError(UniversalVideoView.this.mMediaPlayer, framework_err, impl_err)) {
                return true;
            }
            return true;
        }
    };
    private MediaPlayer.OnBufferingUpdateListener mBufferingUpdateListener = new MediaPlayer.OnBufferingUpdateListener(){

        public void onBufferingUpdate(MediaPlayer mp, int percent) {
            UniversalVideoView.this.mCurrentBufferPercentage = percent;
        }
    };
    SurfaceHolder.Callback mSHCallback = new SurfaceHolder.Callback(){

        public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
            boolean hasValidSize;
            UniversalVideoView.this.mSurfaceWidth = w;
            UniversalVideoView.this.mSurfaceHeight = h;
            boolean isValidState = UniversalVideoView.this.mTargetState == 3;
            boolean bl = hasValidSize = UniversalVideoView.this.mVideoWidth == w && UniversalVideoView.this.mVideoHeight == h;
            if (UniversalVideoView.this.mMediaPlayer != null && isValidState && hasValidSize) {
                if (UniversalVideoView.this.mSeekWhenPrepared != 0) {
                    UniversalVideoView.this.seekTo(UniversalVideoView.this.mSeekWhenPrepared);
                }
                UniversalVideoView.this.start();
            }
        }

        public void surfaceCreated(SurfaceHolder holder) {
            UniversalVideoView.this.mSurfaceHolder = holder;
            UniversalVideoView.this.openVideo();
            UniversalVideoView.this.enableOrientationDetect();
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            UniversalVideoView.this.mSurfaceHolder = null;
            if (UniversalVideoView.this.mMediaController != null) {
                UniversalVideoView.this.mMediaController.hide();
            }
            UniversalVideoView.this.release(true);
            UniversalVideoView.this.disableOrientationDetect();
        }
    };

    public UniversalVideoView(Context context) {
        this(context, null);
    }

    public UniversalVideoView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public UniversalVideoView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        TypedArray a = this.mContext.obtainStyledAttributes(attrs, R.styleable.UniversalVideoView, 0, 0);
        this.mFitXY = a.getBoolean(R.styleable.UniversalVideoView_uvv_fitXY, false);
        this.mAutoRotation = a.getBoolean(R.styleable.UniversalVideoView_uvv_autoRotation, false);
        a.recycle();
        this.initVideoView();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mFitXY) {
            this.onMeasureFitXY(widthMeasureSpec, heightMeasureSpec);
        } else {
            this.onMeasureKeepAspectRatio(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private void onMeasureFitXY(int widthMeasureSpec, int heightMeasureSpec) {
        int width = UniversalVideoView.getDefaultSize((int)this.mVideoWidth, (int)widthMeasureSpec);
        int height = UniversalVideoView.getDefaultSize((int)this.mVideoHeight, (int)heightMeasureSpec);
        this.setMeasuredDimension(width, height);
    }

    private void onMeasureKeepAspectRatio(int widthMeasureSpec, int heightMeasureSpec) {
        int width = UniversalVideoView.getDefaultSize((int)this.mVideoWidth, (int)widthMeasureSpec);
        int height = UniversalVideoView.getDefaultSize((int)this.mVideoHeight, (int)heightMeasureSpec);
        if (this.mVideoWidth > 0 && this.mVideoHeight > 0) {
            int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
            if (widthSpecMode == 0x40000000 && heightSpecMode == 0x40000000) {
                height = heightSpecSize;
                width = widthSpecSize;
                if (this.mVideoWidth * height < width * this.mVideoHeight) {
                    width = height * this.mVideoWidth / this.mVideoHeight;
                } else if (this.mVideoWidth * height > width * this.mVideoHeight) {
                    height = width * this.mVideoHeight / this.mVideoWidth;
                }
            } else if (widthSpecMode == 0x40000000) {
                width = widthSpecSize;
                height = width * this.mVideoHeight / this.mVideoWidth;
                if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                    height = heightSpecSize;
                }
            } else if (heightSpecMode == 0x40000000) {
                height = heightSpecSize;
                width = height * this.mVideoWidth / this.mVideoHeight;
                if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                    width = widthSpecSize;
                }
            } else {
                width = this.mVideoWidth;
                height = this.mVideoHeight;
                if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                    height = heightSpecSize;
                    width = height * this.mVideoWidth / this.mVideoHeight;
                }
                if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                    width = widthSpecSize;
                    height = width * this.mVideoHeight / this.mVideoWidth;
                }
            }
        }
        this.setMeasuredDimension(width, height);
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName((CharSequence)UniversalVideoView.class.getName());
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        if (Build.VERSION.SDK_INT >= 14) {
            info.setClassName((CharSequence)UniversalVideoView.class.getName());
        }
    }

    public int resolveAdjustedSize(int desiredSize, int measureSpec) {
        return UniversalVideoView.getDefaultSize((int)desiredSize, (int)measureSpec);
    }

    private void initVideoView() {
        this.mVideoWidth = 0;
        this.mVideoHeight = 0;
        this.getHolder().addCallback(this.mSHCallback);
        this.getHolder().setType(3);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.requestFocus();
        this.mCurrentState = 0;
        this.mTargetState = 0;
    }

    @Override
    public void onOrientationChanged(int screenOrientation, OrientationDetector.Direction direction) {
        if (!this.mAutoRotation) {
            return;
        }
        if (direction == OrientationDetector.Direction.PORTRAIT) {
            this.setFullscreen(false, 1);
        } else if (direction == OrientationDetector.Direction.REVERSE_PORTRAIT) {
            this.setFullscreen(false, 7);
        } else if (direction == OrientationDetector.Direction.LANDSCAPE) {
            this.setFullscreen(true, 0);
        } else if (direction == OrientationDetector.Direction.REVERSE_LANDSCAPE) {
            this.setFullscreen(true, 8);
        }
    }

    public void setFitXY(boolean fitXY) {
        this.mFitXY = fitXY;
    }

    public void setAutoRotation(boolean auto) {
        this.mAutoRotation = auto;
    }

    public void setVideoPath(String path) {
        this.setVideoURI(Uri.parse((String)path));
    }

    public void setVideoURI(Uri uri) {
        this.setVideoURI(uri, null);
    }

    public void setVideoURI(Uri uri, Map<String, String> headers) {
        this.mUri = uri;
        this.mSeekWhenPrepared = 0;
        this.openVideo();
        this.requestLayout();
        this.invalidate();
    }

    public void stopPlayback() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.stop();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
            this.mCurrentState = 0;
            this.mTargetState = 0;
        }
    }

    private void openVideo() {
        if (this.mUri == null || this.mSurfaceHolder == null) {
            return;
        }
        AudioManager am = (AudioManager)this.mContext.getSystemService("audio");
        am.requestAudioFocus(null, 3, 1);
        this.release(false);
        try {
            this.mMediaPlayer = new MediaPlayer();
            if (this.mAudioSession != 0) {
                this.mMediaPlayer.setAudioSessionId(this.mAudioSession);
            } else {
                this.mAudioSession = this.mMediaPlayer.getAudioSessionId();
            }
            this.mMediaPlayer.setOnPreparedListener(this.mPreparedListener);
            this.mMediaPlayer.setOnVideoSizeChangedListener(this.mSizeChangedListener);
            this.mMediaPlayer.setOnCompletionListener(this.mCompletionListener);
            this.mMediaPlayer.setOnErrorListener(this.mErrorListener);
            this.mMediaPlayer.setOnInfoListener(this.mInfoListener);
            this.mMediaPlayer.setOnBufferingUpdateListener(this.mBufferingUpdateListener);
            this.mCurrentBufferPercentage = 0;
            this.mMediaPlayer.setDataSource(this.mContext, this.mUri);
            this.mMediaPlayer.setDisplay(this.mSurfaceHolder);
            this.mMediaPlayer.setAudioStreamType(3);
            this.mMediaPlayer.setScreenOnWhilePlaying(true);
            this.mMediaPlayer.prepareAsync();
            this.mCurrentState = 1;
            this.attachMediaController();
        }
        catch (IOException ex) {
            Log.w((String)this.TAG, (String)("Unable to open content: " + this.mUri), (Throwable)ex);
            this.mCurrentState = -1;
            this.mTargetState = -1;
            this.mErrorListener.onError(this.mMediaPlayer, 1, 0);
        }
    }

    public void setMediaController(UniversalMediaController controller) {
        if (this.mMediaController != null) {
            this.mMediaController.hide();
        }
        this.mMediaController = controller;
        this.attachMediaController();
    }

    private void attachMediaController() {
        if (this.mMediaPlayer != null && this.mMediaController != null) {
            this.mMediaController.setMediaPlayer(this);
            this.mMediaController.setEnabled(this.isInPlaybackState());
            this.mMediaController.hide();
        }
    }

    public void setOnPreparedListener(MediaPlayer.OnPreparedListener l) {
        this.mOnPreparedListener = l;
    }

    public void setOnCompletionListener(MediaPlayer.OnCompletionListener l) {
        this.mOnCompletionListener = l;
    }

    public void setOnErrorListener(MediaPlayer.OnErrorListener l) {
        this.mOnErrorListener = l;
    }

    public void setOnInfoListener(MediaPlayer.OnInfoListener l) {
        this.mOnInfoListener = l;
    }

    private void enableOrientationDetect() {
        if (this.mAutoRotation && this.mOrientationDetector == null) {
            this.mOrientationDetector = new OrientationDetector(this.mContext);
            this.mOrientationDetector.setOrientationChangeListener(this);
            this.mOrientationDetector.enable();
        }
    }

    private void disableOrientationDetect() {
        if (this.mOrientationDetector != null) {
            this.mOrientationDetector.disable();
        }
    }

    private void release(boolean cleartargetstate) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.reset();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
            this.mCurrentState = 0;
            if (cleartargetstate) {
                this.mTargetState = 0;
            }
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.isInPlaybackState() && this.mMediaController != null) {
            this.toggleMediaControlsVisibility();
        }
        return false;
    }

    public boolean onTrackballEvent(MotionEvent ev) {
        if (this.isInPlaybackState() && this.mMediaController != null) {
            this.toggleMediaControlsVisibility();
        }
        return false;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        boolean isKeyCodeSupported;
        boolean bl = isKeyCodeSupported = keyCode != 4 && keyCode != 24 && keyCode != 25 && keyCode != 164 && keyCode != 82 && keyCode != 5 && keyCode != 6;
        if (this.isInPlaybackState() && isKeyCodeSupported && this.mMediaController != null) {
            if (keyCode == 79 || keyCode == 85) {
                if (this.mMediaPlayer.isPlaying()) {
                    this.pause();
                    this.mMediaController.show();
                } else {
                    this.start();
                    this.mMediaController.hide();
                }
                return true;
            }
            if (keyCode == 126) {
                if (!this.mMediaPlayer.isPlaying()) {
                    this.start();
                    this.mMediaController.hide();
                }
                return true;
            }
            if (keyCode == 86 || keyCode == 127) {
                if (this.mMediaPlayer.isPlaying()) {
                    this.pause();
                    this.mMediaController.show();
                }
                return true;
            }
            this.toggleMediaControlsVisibility();
        }
        return super.onKeyDown(keyCode, event);
    }

    private void toggleMediaControlsVisibility() {
        if (this.mMediaController.isShowing()) {
            this.mMediaController.hide();
        } else {
            this.mMediaController.show();
        }
    }

    @Override
    public void start() {
        if (!this.mPreparedBeforeStart && this.mMediaController != null) {
            this.mMediaController.showLoading();
        }
        if (this.isInPlaybackState()) {
            this.mMediaPlayer.start();
            this.mCurrentState = 3;
            if (this.videoViewCallback != null) {
                this.videoViewCallback.onStart(this.mMediaPlayer);
            }
        }
        this.mTargetState = 3;
    }

    @Override
    public void pause() {
        if (this.isInPlaybackState() && this.mMediaPlayer.isPlaying()) {
            this.mMediaPlayer.pause();
            this.mCurrentState = 4;
            if (this.videoViewCallback != null) {
                this.videoViewCallback.onPause(this.mMediaPlayer);
            }
        }
        this.mTargetState = 4;
    }

    public void suspend() {
        this.release(false);
    }

    public void resume() {
        this.openVideo();
    }

    @Override
    public int getDuration() {
        if (this.isInPlaybackState()) {
            return this.mMediaPlayer.getDuration();
        }
        return -1;
    }

    @Override
    public int getCurrentPosition() {
        if (this.isInPlaybackState()) {
            return this.mMediaPlayer.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public void seekTo(int msec) {
        if (this.isInPlaybackState()) {
            this.mMediaPlayer.seekTo(msec);
            this.mSeekWhenPrepared = 0;
        } else {
            this.mSeekWhenPrepared = msec;
        }
    }

    @Override
    public boolean isPlaying() {
        return this.isInPlaybackState() && this.mMediaPlayer.isPlaying();
    }

    @Override
    public int getBufferPercentage() {
        if (this.mMediaPlayer != null) {
            return this.mCurrentBufferPercentage;
        }
        return 0;
    }

    private boolean isInPlaybackState() {
        return this.mMediaPlayer != null && this.mCurrentState != -1 && this.mCurrentState != 0 && this.mCurrentState != 1;
    }

    @Override
    public boolean canPause() {
        return this.mCanPause;
    }

    @Override
    public boolean canSeekBackward() {
        return this.mCanSeekBack;
    }

    @Override
    public boolean canSeekForward() {
        return this.mCanSeekForward;
    }

    @Override
    public void closePlayer() {
        this.release(true);
    }

    @Override
    public void setFullscreen(boolean fullscreen) {
        int screenOrientation = fullscreen ? 0 : 1;
        this.setFullscreen(fullscreen, screenOrientation);
    }

    @Override
    public void setFullscreen(boolean fullscreen, int screenOrientation) {
        Activity activity = (Activity)this.mContext;
        if (fullscreen) {
            if (this.mVideoViewLayoutWidth == 0 && this.mVideoViewLayoutHeight == 0) {
                ViewGroup.LayoutParams params = this.getLayoutParams();
                this.mVideoViewLayoutWidth = params.width;
                this.mVideoViewLayoutHeight = params.height;
            }
            activity.getWindow().addFlags(1024);
            activity.setRequestedOrientation(screenOrientation);
        } else {
            ViewGroup.LayoutParams params = this.getLayoutParams();
            params.width = this.mVideoViewLayoutWidth;
            params.height = this.mVideoViewLayoutHeight;
            this.setLayoutParams(params);
            activity.getWindow().clearFlags(1024);
            activity.setRequestedOrientation(screenOrientation);
        }
        this.mMediaController.toggleButtons(fullscreen);
        if (this.videoViewCallback != null) {
            this.videoViewCallback.onScaleChange(fullscreen);
        }
    }

    public void setVideoViewCallback(VideoViewCallback callback) {
        this.videoViewCallback = callback;
    }

    public static interface VideoViewCallback {
        public void onScaleChange(boolean var1);

        public void onPause(MediaPlayer var1);

        public void onStart(MediaPlayer var1);

        public void onBufferingStart(MediaPlayer var1);

        public void onBufferingEnd(MediaPlayer var1);
    }
}

