/*
 * Decompiled with CFR 0.152.
 */
package com.universalvideoview;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.TypedArray;
import android.media.AudioManager;
import android.os.Handler;
import android.os.Message;
import android.provider.Settings;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import com.universalvideoview.R;
import java.util.Calendar;
import java.util.Formatter;
import java.util.Locale;

public class UniversalMediaController
extends FrameLayout {
    private MediaPlayerControl mPlayer;
    private Context mContext;
    private ProgressBar mProgress;
    private TextView mEndTime;
    private TextView mCurrentTime;
    private TextView mTitle;
    private boolean mShowing = true;
    private boolean mDragging;
    private boolean mScalable = false;
    private boolean mIsFullScreen = false;
    private static final int sDefaultTimeout = 3000;
    private static final int STATE_PLAYING = 1;
    private static final int STATE_PAUSE = 2;
    private static final int STATE_LOADING = 3;
    private static final int STATE_ERROR = 4;
    private static final int STATE_COMPLETE = 5;
    private int mState = -1;
    private static final int FADE_OUT = 1;
    private static final int SHOW_PROGRESS = 2;
    private static final int SHOW_LOADING = 3;
    private static final int HIDE_LOADING = 4;
    private static final int SHOW_ERROR = 5;
    private static final int HIDE_ERROR = 6;
    private static final int SHOW_COMPLETE = 7;
    private static final int HIDE_COMPLETE = 8;
    StringBuilder mFormatBuilder;
    Formatter mFormatter;
    private ImageButton mTurnButton;
    private ImageButton mScaleButton;
    private View mBackButton;
    private ViewGroup loadingLayout;
    private ViewGroup errorLayout;
    private View mTitleLayout;
    private View mControlLayout;
    private View mCenterPlayButton;
    private TextView tv_time;
    private LinearLayout center_move;
    private ImageView iv_move;
    private TextView tv_move_time;
    private TextView tv_totla_time;
    private LinearLayout light_view;
    private SeekBar light_seekbar;
    private int currentBrightness;
    private int brightness;
    private int voiceness;
    private LinearLayout voice_view;
    private SeekBar voice_seekbar;
    private int voiceMax;
    private int currentVoice;
    private AudioManager mAudioManager;
    private ImageView iv_voice;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    UniversalMediaController.this.hide();
                    break;
                }
                case 2: {
                    int pos = UniversalMediaController.this.setProgress();
                    if (UniversalMediaController.this.mDragging || !UniversalMediaController.this.mShowing || UniversalMediaController.this.mPlayer == null || !UniversalMediaController.this.mPlayer.isPlaying()) break;
                    msg = this.obtainMessage(2);
                    this.sendMessageDelayed(msg, 1000 - pos % 1000);
                    break;
                }
                case 3: {
                    UniversalMediaController.this.show();
                    UniversalMediaController.this.showCenterView(R.id.loading_layout);
                    UniversalMediaController.this.mState = 3;
                    break;
                }
                case 7: {
                    UniversalMediaController.this.showCenterView(R.id.center_play_btn);
                    break;
                }
                case 5: {
                    UniversalMediaController.this.show();
                    UniversalMediaController.this.showCenterView(R.id.error_layout);
                    break;
                }
                case 4: 
                case 6: 
                case 8: {
                    UniversalMediaController.this.hide();
                    UniversalMediaController.this.hideCenterView();
                    UniversalMediaController.this.mState = 4;
                }
            }
        }
    };
    private static final int MOVE_DEFAULT = -1;
    private static final int MOVE_PROGRESS = 10010;
    private static final int MOVE_LIGHT = 10011;
    private static final int MOVE_VOICE = 10012;
    int newposition = 0;
    int moveState = -1;
    float downX = 0.0f;
    float downY = 0.0f;
    float moveX = 0.0f;
    float moveY = 0.0f;
    float lastX = 0.0f;
    float lastY;
    boolean movingProgress = false;
    boolean movingLight = false;
    boolean movingVoice = false;
    boolean handled = false;
    private View.OnTouchListener mTouchListener = new View.OnTouchListener(){

        public boolean onTouch(View v, MotionEvent event) {
            if (event.getAction() == 0 && UniversalMediaController.this.mShowing) {
                UniversalMediaController.this.hide();
                UniversalMediaController.this.handled = true;
                return true;
            }
            return false;
        }
    };
    private View.OnClickListener mPauseListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (UniversalMediaController.this.mPlayer != null) {
                UniversalMediaController.this.doPauseResume();
                UniversalMediaController.this.show(3000);
            }
        }
    };
    private View.OnClickListener mScaleListener = new View.OnClickListener(){

        public void onClick(View v) {
            UniversalMediaController.this.mIsFullScreen = !UniversalMediaController.this.mIsFullScreen;
            UniversalMediaController.this.updateScaleButton();
            UniversalMediaController.this.updateBackButton();
            UniversalMediaController.this.updateTitleBar();
            UniversalMediaController.this.mPlayer.setFullscreen(UniversalMediaController.this.mIsFullScreen);
        }
    };
    private View.OnClickListener mBackListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (UniversalMediaController.this.mIsFullScreen) {
                UniversalMediaController.this.mIsFullScreen = false;
                UniversalMediaController.this.updateScaleButton();
                UniversalMediaController.this.updateBackButton();
                UniversalMediaController.this.updateTitleBar();
                UniversalMediaController.this.mPlayer.setFullscreen(false);
            }
        }
    };
    private View.OnClickListener mCenterPlayListener = new View.OnClickListener(){

        public void onClick(View v) {
            UniversalMediaController.this.hideCenterView();
            UniversalMediaController.this.mPlayer.start();
        }
    };
    private SeekBar.OnSeekBarChangeListener mSeekListener = new SeekBar.OnSeekBarChangeListener(){
        int newPosition = 0;
        boolean change = false;

        public void onStartTrackingTouch(SeekBar bar) {
            if (UniversalMediaController.this.mPlayer == null) {
                return;
            }
            UniversalMediaController.this.show(3600000);
            UniversalMediaController.this.mDragging = true;
            UniversalMediaController.this.mHandler.removeMessages(2);
        }

        public void onProgressChanged(SeekBar bar, int progress, boolean fromuser) {
            if (UniversalMediaController.this.mPlayer == null || !fromuser) {
                return;
            }
            long duration = UniversalMediaController.this.mPlayer.getDuration();
            long newposition = duration * (long)progress / 1000L;
            this.newPosition = (int)newposition;
            this.change = true;
        }

        public void onStopTrackingTouch(SeekBar bar) {
            if (UniversalMediaController.this.mPlayer == null) {
                return;
            }
            if (this.change) {
                UniversalMediaController.this.mPlayer.seekTo(this.newPosition);
                if (UniversalMediaController.this.mCurrentTime != null) {
                    UniversalMediaController.this.mCurrentTime.setText((CharSequence)UniversalMediaController.this.stringForTime(this.newPosition));
                }
            }
            UniversalMediaController.this.mDragging = false;
            UniversalMediaController.this.setProgress();
            UniversalMediaController.this.updatePausePlay();
            UniversalMediaController.this.show(3000);
            UniversalMediaController.this.mShowing = true;
            UniversalMediaController.this.mHandler.sendEmptyMessage(2);
        }
    };

    public UniversalMediaController(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        TypedArray a = this.mContext.obtainStyledAttributes(attrs, R.styleable.UniversalMediaController);
        this.mScalable = a.getBoolean(R.styleable.UniversalMediaController_uvv_scalable, false);
        a.recycle();
        this.init(context);
    }

    public UniversalMediaController(Context context) {
        super(context);
        this.init(context);
    }

    private void init(Context context) {
        this.mContext = context;
        LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        View viewRoot = inflater.inflate(R.layout.uvv_player_controller, (ViewGroup)this);
        viewRoot.setOnTouchListener(this.mTouchListener);
        this.initControllerView(viewRoot);
    }

    private void initControllerView(View v) {
        this.mTitleLayout = v.findViewById(R.id.title_part);
        this.mControlLayout = v.findViewById(R.id.control_layout);
        this.loadingLayout = (ViewGroup)v.findViewById(R.id.loading_layout);
        this.errorLayout = (ViewGroup)v.findViewById(R.id.error_layout);
        this.mTurnButton = (ImageButton)v.findViewById(R.id.turn_button);
        this.mScaleButton = (ImageButton)v.findViewById(R.id.scale_button);
        this.mCenterPlayButton = v.findViewById(R.id.center_play_btn);
        this.mBackButton = v.findViewById(R.id.back_btn);
        this.tv_time = (TextView)v.findViewById(R.id.tv_time);
        this.center_move = (LinearLayout)v.findViewById(R.id.center_move);
        this.iv_move = (ImageView)v.findViewById(R.id.iv_move);
        this.tv_move_time = (TextView)v.findViewById(R.id.tv_move_time);
        this.tv_totla_time = (TextView)v.findViewById(R.id.tv_total_time);
        this.voice_view = (LinearLayout)v.findViewById(R.id.voice_view);
        this.voice_seekbar = (SeekBar)v.findViewById(R.id.voice_seekbar);
        this.iv_voice = (ImageView)v.findViewById(R.id.iv_voice);
        this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
        this.voiceMax = this.mAudioManager.getStreamMaxVolume(3);
        this.currentVoice = this.mAudioManager.getStreamVolume(3);
        this.voice_seekbar.setMax(this.voiceMax);
        this.voice_seekbar.setProgress(this.currentVoice);
        this.light_view = (LinearLayout)v.findViewById(R.id.light_view);
        this.light_seekbar = (SeekBar)v.findViewById(R.id.light_seekbar);
        this.light_seekbar.setMax(255);
        this.currentBrightness = this.getSystemBrightness();
        this.light_seekbar.setProgress(this.currentBrightness);
        if (this.mTurnButton != null) {
            this.mTurnButton.requestFocus();
            this.mTurnButton.setOnClickListener(this.mPauseListener);
        }
        if (this.mScalable) {
            if (this.mScaleButton != null) {
                this.mScaleButton.setVisibility(0);
                this.mScaleButton.setOnClickListener(this.mScaleListener);
            }
        } else if (this.mScaleButton != null) {
            this.mScaleButton.setVisibility(8);
        }
        if (this.mCenterPlayButton != null) {
            this.mCenterPlayButton.setOnClickListener(this.mCenterPlayListener);
        }
        if (this.mBackButton != null) {
            this.mBackButton.setOnClickListener(this.mBackListener);
        }
        View bar = v.findViewById(R.id.seekbar);
        this.mProgress = (ProgressBar)bar;
        if (this.mProgress != null) {
            if (this.mProgress instanceof SeekBar) {
                SeekBar seeker = (SeekBar)this.mProgress;
                seeker.setOnSeekBarChangeListener(this.mSeekListener);
            }
            this.mProgress.setMax(1000);
        }
        this.mEndTime = (TextView)v.findViewById(R.id.duration);
        this.mCurrentTime = (TextView)v.findViewById(R.id.has_played);
        this.mTitle = (TextView)v.findViewById(R.id.title);
        this.mFormatBuilder = new StringBuilder();
        this.mFormatter = new Formatter(this.mFormatBuilder, Locale.getDefault());
        this.setSystemTime();
    }

    private int getSystemBrightness() {
        int systemBrightness = 0;
        Activity activity = (Activity)this.mContext;
        try {
            systemBrightness = Settings.System.getInt((ContentResolver)activity.getContentResolver(), (String)"screen_brightness");
        }
        catch (Settings.SettingNotFoundException e) {
            e.printStackTrace();
        }
        return systemBrightness;
    }

    public void changeAppBrightness(int brightness) {
        Activity activity = (Activity)this.mContext;
        Window window = activity.getWindow();
        WindowManager.LayoutParams lp = window.getAttributes();
        lp.screenBrightness = brightness == -1 ? -1.0f : (float)(brightness <= 0 ? 1 : brightness) / 255.0f;
        window.setAttributes(lp);
    }

    private void setSystemTime() {
        Calendar c = Calendar.getInstance();
        int hour = c.get(11);
        int minute = c.get(12);
        String hourStr = hour < 10 ? "0" + hour : hour + "";
        String minuteStr = minute < 10 ? "0" + minute : minute + "";
        this.tv_time.setText((CharSequence)(hourStr + ":" + minuteStr));
    }

    public void setMediaPlayer(MediaPlayerControl player) {
        this.mPlayer = player;
        this.updatePausePlay();
    }

    public void show() {
        this.show(3000);
    }

    private void disableUnsupportedButtons() {
        try {
            if (this.mTurnButton != null && this.mPlayer != null && !this.mPlayer.canPause()) {
                this.mTurnButton.setEnabled(false);
            }
        }
        catch (IncompatibleClassChangeError incompatibleClassChangeError) {
            // empty catch block
        }
    }

    public void show(int timeout) {
        if (!this.mShowing) {
            this.setProgress();
            if (this.mTurnButton != null) {
                this.mTurnButton.requestFocus();
            }
            this.disableUnsupportedButtons();
            this.mShowing = true;
        }
        this.updatePausePlay();
        this.updateBackButton();
        this.updateTitleBar();
        if (this.getVisibility() != 0) {
            this.setVisibility(0);
        }
        if (this.mControlLayout.getVisibility() != 0) {
            this.mControlLayout.setVisibility(0);
        }
        this.setSystemTime();
        this.mHandler.sendEmptyMessage(2);
        Message msg = this.mHandler.obtainMessage(1);
        if (timeout != 0) {
            this.mHandler.removeMessages(1);
            this.mHandler.sendMessageDelayed(msg, (long)timeout);
        }
    }

    public boolean isShowing() {
        return this.mShowing;
    }

    public void hide() {
        if (this.mShowing) {
            this.mHandler.removeMessages(2);
            this.mTitleLayout.setVisibility(8);
            this.mControlLayout.setVisibility(8);
            this.mShowing = false;
        }
    }

    private void showCenterView(int resId) {
        if (resId == R.id.loading_layout) {
            if (this.loadingLayout.getVisibility() != 0) {
                this.loadingLayout.setVisibility(0);
            }
            if (this.mCenterPlayButton.getVisibility() == 0) {
                this.mCenterPlayButton.setVisibility(8);
            }
            if (this.errorLayout.getVisibility() == 0) {
                this.errorLayout.setVisibility(8);
            }
        } else if (resId == R.id.center_play_btn) {
            if (this.mCenterPlayButton.getVisibility() != 0) {
                this.mCenterPlayButton.setVisibility(0);
            }
            if (this.loadingLayout.getVisibility() == 0) {
                this.loadingLayout.setVisibility(8);
            }
            if (this.errorLayout.getVisibility() == 0) {
                this.errorLayout.setVisibility(8);
            }
        } else if (resId == R.id.error_layout) {
            if (this.errorLayout.getVisibility() != 0) {
                this.errorLayout.setVisibility(0);
            }
            if (this.mCenterPlayButton.getVisibility() == 0) {
                this.mCenterPlayButton.setVisibility(8);
            }
            if (this.loadingLayout.getVisibility() == 0) {
                this.loadingLayout.setVisibility(8);
            }
        }
    }

    private void hideCenterView() {
        if (this.mCenterPlayButton.getVisibility() == 0) {
            this.mCenterPlayButton.setVisibility(8);
        }
        if (this.errorLayout.getVisibility() == 0) {
            this.errorLayout.setVisibility(8);
        }
        if (this.loadingLayout.getVisibility() == 0) {
            this.loadingLayout.setVisibility(8);
        }
    }

    public void reset() {
        this.mCurrentTime.setText((CharSequence)"00:00");
        this.mEndTime.setText((CharSequence)"/00:00");
        this.mProgress.setProgress(0);
        this.mTurnButton.setImageResource(R.drawable.video_play);
        this.setVisibility(0);
        this.hideLoading();
    }

    private String stringForTime(int timeMs) {
        int totalSeconds = timeMs / 1000;
        int seconds = totalSeconds % 60;
        int minutes = totalSeconds / 60 % 60;
        int hours = totalSeconds / 3600;
        this.mFormatBuilder.setLength(0);
        if (hours > 0) {
            return this.mFormatter.format("%d:%02d:%02d", hours, minutes, seconds).toString();
        }
        return this.mFormatter.format("%02d:%02d", minutes, seconds).toString();
    }

    private int setProgress() {
        if (this.mPlayer == null || this.mDragging) {
            return 0;
        }
        int position = this.mPlayer.getCurrentPosition();
        int duration = this.mPlayer.getDuration();
        if (this.mProgress != null) {
            if (duration > 0) {
                long pos = 1000L * (long)position / (long)duration;
                this.mProgress.setProgress((int)pos);
            }
            int percent = this.mPlayer.getBufferPercentage();
            this.mProgress.setSecondaryProgress(percent * 10);
        }
        if (this.mEndTime != null) {
            this.mEndTime.setText((CharSequence)("/" + this.stringForTime(duration)));
        }
        if (this.mCurrentTime != null) {
            this.mCurrentTime.setText((CharSequence)this.stringForTime(position));
        }
        return position;
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.show(0);
                this.handled = false;
                if (!this.mIsFullScreen) break;
                this.downX = event.getX();
                this.downY = event.getY();
                this.lastX = this.downX;
                this.lastY = this.downY;
                break;
            }
            case 2: {
                int movedY;
                if (!this.mIsFullScreen) break;
                Log.i((String)"move", (String)("\u79fb\u52a8\u7684x\u5750\u6807" + this.moveX));
                Log.i((String)"moveY", (String)("\u79fb\u52a8\u7684y\u5750\u6807" + this.moveY));
                this.moveX = event.getX();
                this.moveY = event.getY();
                if (this.moveState == -1) {
                    if (Math.abs(this.moveX - this.downX) - Math.abs(this.moveY - this.downY) > 50.0f && this.downX > (float)(this.getWidth() / 4) && this.downX < (float)(this.getWidth() / 4 * 3)) {
                        this.moveState = 10010;
                    } else if (Math.abs(this.moveX - this.downX) - Math.abs(this.moveY - this.downY) < 50.0f && this.downX < (float)(this.getWidth() / 4)) {
                        this.moveState = 10011;
                    } else if (Math.abs(this.moveX - this.downX) - Math.abs(this.moveY - this.downY) < 50.0f && this.downX > (float)(this.getWidth() / 4 * 3)) {
                        this.moveState = 10012;
                    }
                }
                if (!this.movingLight && !this.movingVoice && this.mState != 3 && this.moveState == 10010) {
                    this.movingProgress = true;
                    int movedX = (int)(this.moveX - this.downX);
                    long duration = this.mPlayer.getDuration();
                    long nowPositon = this.mPlayer.getCurrentPosition();
                    this.newposition = (int)((long)((int)nowPositon) + (long)movedX * duration / (long)this.getWidth() / 2L);
                    this.mPlayer.pause();
                    this.setImageViewCenter(this.moveX - this.lastX);
                    this.updateMovedText(this.newposition, duration);
                }
                if (!this.movingProgress && !this.movingVoice && this.moveState == 10011) {
                    this.movingLight = true;
                    this.upateLightView(true);
                    movedY = (int)(this.downY - this.moveY);
                    this.brightness = this.currentBrightness + movedY / 10;
                    if (this.brightness > 255) {
                        this.brightness = 255;
                    } else if (this.brightness <= 0) {
                        this.brightness = 0;
                    }
                    Log.i((String)"brightness", (String)("\u5f53\u524d\u8bbe\u7f6e\u7684\u4eae\u5ea6" + this.brightness));
                    this.changeAppBrightness(this.brightness);
                    this.updateLightSeekBar(this.brightness);
                }
                if (!this.movingProgress && !this.movingLight && this.moveState == 10012) {
                    this.movingVoice = true;
                    this.updateVoiceView(true);
                    movedY = (int)(this.downY - this.moveY);
                    this.voiceness = this.currentVoice + movedY / 30;
                    if (this.voiceness > this.voiceMax) {
                        this.voiceness = this.voiceMax;
                    } else if (this.voiceness <= 0) {
                        this.voiceness = 0;
                    }
                    Log.i((String)"voiceness", (String)("\u5f53\u524d\u8bbe\u7f6e\u7684\u58f0\u97f3" + this.voiceness));
                    this.changeAppVoiceness(this.voiceness);
                    this.updateVoiceSeekBar(this.voiceness);
                }
                this.lastX = this.moveX;
                this.lastY = this.moveY;
                break;
            }
            case 1: {
                this.moveState = -1;
                if (!this.handled) {
                    this.handled = false;
                    this.show(3000);
                }
                if (this.movingLight && this.isFullScreen()) {
                    this.currentBrightness = this.brightness;
                    this.upateLightView(false);
                    this.movingLight = false;
                }
                if (this.movingVoice && this.mIsFullScreen) {
                    this.currentVoice = this.voiceness;
                    this.updateVoiceView(false);
                    this.movingVoice = false;
                }
                if (this.mPlayer == null || !this.movingProgress || !this.isFullScreen()) break;
                this.mPlayer.start();
                this.center_move.setVisibility(8);
                this.mPlayer.seekTo(this.newposition);
                if (this.mCurrentTime != null) {
                    this.mCurrentTime.setText((CharSequence)this.stringForTime(this.newposition));
                }
                this.setProgress();
                this.updatePausePlay();
                this.show(3000);
                this.movingProgress = false;
                this.mShowing = true;
                this.mHandler.sendEmptyMessage(2);
                break;
            }
            case 3: {
                this.hide();
                break;
            }
        }
        return true;
    }

    private void updateVoiceSeekBar(int voiceness) {
        if (voiceness > 0 && voiceness < this.voiceMax) {
            this.voice_seekbar.setProgress(voiceness);
        } else if (voiceness < 0) {
            this.voice_seekbar.setProgress(0);
        } else if (voiceness >= this.voiceMax) {
            this.voice_seekbar.setProgress(this.voiceMax);
        }
    }

    private void changeAppVoiceness(int voiceness) {
        this.iv_voice.setImageResource(R.drawable.video_volume);
        if (voiceness > this.voiceMax) {
            voiceness = this.voiceMax;
        } else if (voiceness <= 0) {
            voiceness = 0;
            this.iv_voice.setImageResource(R.drawable.video_mute);
        }
        this.mAudioManager.setStreamVolume(3, voiceness, 4);
    }

    private void updateVoiceView(boolean isVoiceShow) {
        if (isVoiceShow) {
            this.voice_view.setVisibility(0);
        } else {
            this.voice_view.setVisibility(8);
        }
    }

    private void updateLightSeekBar(int brightness) {
        if (brightness > 0 && brightness < 256) {
            this.light_seekbar.setProgress(brightness);
        } else if (brightness < 0) {
            this.light_seekbar.setProgress(0);
        } else if (brightness >= 256) {
            this.light_seekbar.setProgress(255);
        }
    }

    private void upateLightView(boolean isLightShow) {
        if (isLightShow) {
            this.light_view.setVisibility(0);
        } else {
            this.light_view.setVisibility(8);
        }
    }

    private void updateMovedText(int newposition, long duration) {
        if (newposition > 0 && (long)newposition < duration) {
            this.tv_move_time.setText((CharSequence)this.stringForTime(newposition));
        } else if ((long)newposition > duration) {
            this.tv_move_time.setText((CharSequence)this.stringForTime((int)duration));
        }
        if (duration > 0L) {
            this.tv_totla_time.setText((CharSequence)("/" + this.stringForTime((int)duration)));
        }
    }

    private void setImageViewCenter(float offsetX) {
        this.center_move.setVisibility(0);
        if (offsetX > 0.0f) {
            this.iv_move.setImageResource(R.drawable.video_fast);
        } else {
            this.iv_move.setImageResource(R.drawable.video_rewind);
        }
    }

    public boolean onTrackballEvent(MotionEvent ev) {
        this.show(3000);
        return false;
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        boolean uniqueDown;
        int keyCode = event.getKeyCode();
        boolean bl = uniqueDown = event.getRepeatCount() == 0 && event.getAction() == 0;
        if (keyCode == 79 || keyCode == 85 || keyCode == 62) {
            if (uniqueDown) {
                this.doPauseResume();
                this.show(3000);
                if (this.mTurnButton != null) {
                    this.mTurnButton.requestFocus();
                }
            }
            return true;
        }
        if (keyCode == 126) {
            if (uniqueDown && !this.mPlayer.isPlaying()) {
                this.mPlayer.start();
                this.updatePausePlay();
                this.show(3000);
            }
            return true;
        }
        if (keyCode == 86 || keyCode == 127) {
            if (uniqueDown && this.mPlayer.isPlaying()) {
                this.mPlayer.pause();
                this.updatePausePlay();
                this.show(3000);
            }
            return true;
        }
        if (keyCode == 25 || keyCode == 24 || keyCode == 164 || keyCode == 27) {
            return super.dispatchKeyEvent(event);
        }
        if (keyCode == 4 || keyCode == 82) {
            if (uniqueDown) {
                this.hide();
            }
            return true;
        }
        this.show(3000);
        return super.dispatchKeyEvent(event);
    }

    private void updatePausePlay() {
        if (this.mPlayer != null && this.mPlayer.isPlaying()) {
            this.mTurnButton.setImageResource(R.drawable.video_suspend);
        } else {
            this.mTurnButton.setImageResource(R.drawable.video_play);
        }
    }

    void updateScaleButton() {
        if (this.mIsFullScreen) {
            this.mScaleButton.setImageResource(R.drawable.video_narrow);
        } else {
            this.mScaleButton.setImageResource(R.drawable.video_enlarge);
        }
    }

    void toggleButtons(boolean isFullScreen) {
        this.mIsFullScreen = isFullScreen;
        this.updateScaleButton();
        this.updateBackButton();
        this.updateTitleBar();
    }

    private void updateTitleBar() {
        this.mTitleLayout.setVisibility(this.mIsFullScreen ? 0 : 4);
    }

    void updateBackButton() {
        this.mBackButton.setVisibility(this.mIsFullScreen ? 0 : 4);
    }

    boolean isFullScreen() {
        return this.mIsFullScreen;
    }

    private void doPauseResume() {
        if (this.mPlayer.isPlaying()) {
            this.mPlayer.pause();
        } else {
            this.mPlayer.start();
        }
        this.updatePausePlay();
    }

    public void setEnabled(boolean enabled) {
        if (this.mTurnButton != null) {
            this.mTurnButton.setEnabled(enabled);
        }
        if (this.mProgress != null) {
            this.mProgress.setEnabled(enabled);
        }
        if (this.mScalable) {
            this.mScaleButton.setEnabled(enabled);
        }
        this.mBackButton.setEnabled(true);
    }

    public void showLoading() {
        this.mHandler.sendEmptyMessage(3);
    }

    public void hideLoading() {
        this.mHandler.sendEmptyMessage(4);
    }

    public void showError() {
        this.mHandler.sendEmptyMessage(5);
    }

    public void hideError() {
        this.mHandler.sendEmptyMessage(6);
    }

    public void showComplete() {
        this.mHandler.sendEmptyMessage(7);
    }

    public void hideComplete() {
        this.mHandler.sendEmptyMessage(8);
    }

    public void setTitle(String titile) {
        this.mTitle.setText((CharSequence)titile);
    }

    public void setOnErrorView(int resId) {
        this.errorLayout.removeAllViews();
        LayoutInflater inflater = LayoutInflater.from((Context)this.mContext);
        inflater.inflate(resId, this.errorLayout, true);
    }

    public void setOnErrorView(View onErrorView) {
        this.errorLayout.removeAllViews();
        this.errorLayout.addView(onErrorView);
    }

    public void setOnLoadingView(int resId) {
        this.loadingLayout.removeAllViews();
        LayoutInflater inflater = LayoutInflater.from((Context)this.mContext);
        inflater.inflate(resId, this.loadingLayout, true);
    }

    public void setOnLoadingView(View onLoadingView) {
        this.loadingLayout.removeAllViews();
        this.loadingLayout.addView(onLoadingView);
    }

    public void setOnErrorViewClick(View.OnClickListener onClickListener) {
        this.errorLayout.setOnClickListener(onClickListener);
    }

    public static interface MediaPlayerControl {
        public void start();

        public void pause();

        public int getDuration();

        public int getCurrentPosition();

        public void seekTo(int var1);

        public boolean isPlaying();

        public int getBufferPercentage();

        public boolean canPause();

        public boolean canSeekBackward();

        public boolean canSeekForward();

        public void closePlayer();

        public void setFullscreen(boolean var1);

        public void setFullscreen(boolean var1, int var2);
    }
}

