/*
 * Decompiled with CFR 0.152.
 */
package com.universalvideoview;

import android.content.Context;
import android.util.Log;
import android.view.OrientationEventListener;

public class OrientationDetector {
    private static final String TAG = "OrientationDetector";
    private static final int HOLDING_THRESHOLD = 1500;
    private Context context;
    private OrientationEventListener orientationEventListener;
    private int rotationThreshold = 20;
    private long holdingTime = 0L;
    private long lastCalcTime = 0L;
    private Direction lastDirection = Direction.PORTRAIT;
    private int currentOrientation = 1;
    private OrientationChangeListener listener;

    public OrientationDetector(Context context) {
        this.context = context;
    }

    public void setOrientationChangeListener(OrientationChangeListener listener) {
        this.listener = listener;
    }

    public void enable() {
        if (this.orientationEventListener == null) {
            this.orientationEventListener = new OrientationEventListener(this.context, 2){

                public void onOrientationChanged(int orientation) {
                    Direction currDirection = OrientationDetector.this.calcDirection(orientation);
                    if (currDirection == null) {
                        return;
                    }
                    if (currDirection != OrientationDetector.this.lastDirection) {
                        OrientationDetector.this.resetTime();
                        OrientationDetector.this.lastDirection = currDirection;
                    } else {
                        OrientationDetector.this.calcHoldingTime();
                        if (OrientationDetector.this.holdingTime > 1500L) {
                            if (currDirection == Direction.LANDSCAPE) {
                                if (OrientationDetector.this.currentOrientation != 0) {
                                    Log.d((String)OrientationDetector.TAG, (String)"switch to SCREEN_ORIENTATION_LANDSCAPE");
                                    OrientationDetector.this.currentOrientation = 0;
                                    if (OrientationDetector.this.listener != null) {
                                        OrientationDetector.this.listener.onOrientationChanged(0, currDirection);
                                    }
                                }
                            } else if (currDirection == Direction.PORTRAIT) {
                                if (OrientationDetector.this.currentOrientation != 1) {
                                    Log.d((String)OrientationDetector.TAG, (String)"switch to SCREEN_ORIENTATION_PORTRAIT");
                                    OrientationDetector.this.currentOrientation = 1;
                                    if (OrientationDetector.this.listener != null) {
                                        OrientationDetector.this.listener.onOrientationChanged(1, currDirection);
                                    }
                                }
                            } else if (currDirection == Direction.REVERSE_PORTRAIT) {
                                if (OrientationDetector.this.currentOrientation != 9) {
                                    Log.d((String)OrientationDetector.TAG, (String)"switch to SCREEN_ORIENTATION_REVERSE_PORTRAIT");
                                    OrientationDetector.this.currentOrientation = 9;
                                    if (OrientationDetector.this.listener != null) {
                                        OrientationDetector.this.listener.onOrientationChanged(9, currDirection);
                                    }
                                }
                            } else if (currDirection == Direction.REVERSE_LANDSCAPE && OrientationDetector.this.currentOrientation != 8) {
                                Log.d((String)OrientationDetector.TAG, (String)"switch to SCREEN_ORIENTATION_REVERSE_LANDSCAPE");
                                OrientationDetector.this.currentOrientation = 8;
                                if (OrientationDetector.this.listener != null) {
                                    OrientationDetector.this.listener.onOrientationChanged(8, currDirection);
                                }
                            }
                        }
                    }
                }
            };
        }
        this.orientationEventListener.enable();
    }

    private void calcHoldingTime() {
        long current = System.currentTimeMillis();
        if (this.lastCalcTime == 0L) {
            this.lastCalcTime = current;
        }
        this.holdingTime += current - this.lastCalcTime;
        this.lastCalcTime = current;
    }

    private void resetTime() {
        this.lastCalcTime = 0L;
        this.holdingTime = 0L;
    }

    private Direction calcDirection(int orientation) {
        if (orientation <= this.rotationThreshold || orientation >= 360 - this.rotationThreshold) {
            return Direction.PORTRAIT;
        }
        if (Math.abs(orientation - 180) <= this.rotationThreshold) {
            return Direction.REVERSE_PORTRAIT;
        }
        if (Math.abs(orientation - 90) <= this.rotationThreshold) {
            return Direction.REVERSE_LANDSCAPE;
        }
        if (Math.abs(orientation - 270) <= this.rotationThreshold) {
            return Direction.LANDSCAPE;
        }
        return null;
    }

    public void setInitialDirection(Direction direction) {
        this.lastDirection = direction;
    }

    public void disable() {
        if (this.orientationEventListener != null) {
            this.orientationEventListener.disable();
        }
    }

    public void setThresholdDegree(int degree) {
        this.rotationThreshold = degree;
    }

    public static enum Direction {
        PORTRAIT,
        REVERSE_PORTRAIT,
        LANDSCAPE,
        REVERSE_LANDSCAPE;

    }

    public static interface OrientationChangeListener {
        public void onOrientationChanged(int var1, Direction var2);
    }
}

