/*
 * Decompiled with CFR 0.152.
 */
package abbi.io.abbisdk.model;

import abbi.io.abbisdk.b;
import abbi.io.abbisdk.cf;
import abbi.io.abbisdk.cr;
import abbi.io.abbisdk.cs;
import abbi.io.abbisdk.ct;
import abbi.io.abbisdk.cu;
import abbi.io.abbisdk.cy;
import abbi.io.abbisdk.d;
import abbi.io.abbisdk.da;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class WMPromotionObject {
    protected long mPromotionId;
    @Nullable
    protected cs.b mTrigger;
    @Nullable
    private String mUrl;
    private int mPriority;
    protected int mCap;
    @Nullable
    private String mName;
    @Nullable
    private String mUiType;
    private boolean mIsActive;
    @Nullable
    protected cs.a mCls;
    @NonNull
    private List<cu> mActions = new ArrayList<cu>();
    private long mPromotionRevisionId;
    private int mInSessionCap = 1;
    private String mDirection = "ltr";
    private String mRevisionId = "-1";
    private String mCampaignRevisionId = "";
    private ct mPromotionEventsData;
    private int mDisplayCount;
    private boolean mWasImpressionSent;
    private long mLastCtaId;
    @Nullable
    private String mLastCta;
    @Nullable
    private Boolean mIsRequestAccessibilityFocus;
    @NonNull
    private ArrayList<Long> mLabels = new ArrayList();

    public WMPromotionObject() {
        this.mPromotionEventsData = new ct();
    }

    public WMPromotionObject(@NonNull JSONObject jSONObject) {
        this();
        JSONObject jSONObject2;
        JSONObject jSONObject3;
        this.mPromotionId = jSONObject.optLong("_id");
        this.mTrigger = this.parseTrigger(jSONObject.optInt("trigger"));
        this.mUrl = jSONObject.optString("url");
        this.mPriority = jSONObject.optInt("priority", 1);
        this.mCap = jSONObject.optInt("cap", 1);
        if (this.mCap == -1) {
            this.mCap = Integer.MAX_VALUE;
        }
        try {
            jSONObject3 = jSONObject.optJSONObject("frequency");
            if (jSONObject3 != null && (jSONObject2 = jSONObject3.optJSONObject("inSession")) != null && jSONObject2.optString("type").equals("impressions")) {
                this.mInSessionCap = jSONObject2.optInt("interval", 1);
                if (this.mInSessionCap == -1) {
                    this.mInSessionCap = Integer.MAX_VALUE;
                }
            }
        }
        catch (Exception exception) {
            cf.a("" + exception.getMessage(), new Object[0]);
        }
        this.mName = jSONObject.optString("name");
        this.mIsActive = jSONObject.optBoolean("enabled");
        this.mCls = WMPromotionObject.parseCls(jSONObject.optString("cls"));
        this.mPromotionEventsData.a(jSONObject.optString("key", ""));
        this.mCampaignRevisionId = jSONObject.optString("campaign_revision_id");
        this.mPromotionRevisionId = jSONObject.optLong("promotion_revision_id", 1L);
        this.mRevisionId = jSONObject.optString("revision_id", "-1");
        this.mUiType = jSONObject.optString("ui_type");
        this.mActions = new ArrayList<cu>();
        jSONObject3 = jSONObject.optJSONArray("actions");
        if (jSONObject3 != null) {
            for (int i2 = 0; i2 < jSONObject3.length(); ++i2) {
                try {
                    this.mActions.add(new cu(jSONObject3.getJSONObject(i2)));
                    continue;
                }
                catch (Exception exception) {
                    cf.a("Can't add action object from JSON - " + exception.getMessage(), new Object[0]);
                }
            }
        }
        if (this.mName == null) {
            this.mName = jSONObject.optString("name");
        }
        if (this.mPromotionId == 0L) {
            this.mPromotionId = jSONObject.optLong("promotionID");
        }
        this.mIsRequestAccessibilityFocus = (jSONObject2 = jSONObject.optJSONObject("accessibility")) != null ? Boolean.valueOf(jSONObject2.optBoolean("requestAccessibilityFocus")) : null;
        this.mDirection = jSONObject.optString("direction", "ltr");
        this.setLabels(jSONObject);
    }

    @Nullable
    public static WMPromotionObject promotionWithData(@NonNull JSONObject jSONObject) {
        int n2 = jSONObject.optInt("version");
        cs.a a2 = WMPromotionObject.parseCls(jSONObject.optString("cls"));
        if (a2 != null) {
            switch (a2) {
                case a: 
                case f: 
                case h: {
                    return new cy(jSONObject, n2, 0L);
                }
                case g: {
                    return new cr(jSONObject, n2, 0L);
                }
                case b: 
                case c: {
                    return new da(jSONObject, n2);
                }
            }
        }
        return null;
    }

    @Nullable
    private cs.b parseTrigger(int n2) {
        switch (n2) {
            case -1: {
                this.mPromotionEventsData.a(ct.b.c);
                return cs.b.a;
            }
            case 0: {
                this.mPromotionEventsData.a(ct.b.f);
                return cs.b.b;
            }
            case 1: {
                this.mPromotionEventsData.a(ct.b.e);
                return cs.b.c;
            }
        }
        return null;
    }

    @Nullable
    private static cs.a parseCls(@NonNull String string) {
        switch (string) {
            case "PROMOTION_BUILDER": {
                return cs.a.a;
            }
            case "WALKTHROUGH": {
                return cs.a.b;
            }
            case "SWT": {
                return cs.a.c;
            }
            case "SWT_SPLIT": {
                return cs.a.d;
            }
            case "SWT_PENDING": {
                return cs.a.e;
            }
            case "SURVEY": {
                return cs.a.f;
            }
            case "NATIVE_SURVEY": {
                return cs.a.h;
            }
            case "LAUNCHER": {
                return cs.a.g;
            }
            case "WAIT_FOR": {
                return cs.a.i;
            }
            case "WM_DATA": {
                return cs.a.j;
            }
            case "SWT_CONNECTED": {
                return cs.a.k;
            }
        }
        return null;
    }

    public int getPromotionCount() {
        d d2 = d.a();
        return d2 != null ? d2.d(this.mPromotionId) : 0;
    }

    public boolean didReachCappingLimit() {
        d d2 = d.a();
        int n2 = d2 != null ? d2.d(this.mPromotionId) : 0;
        return n2 >= this.mCap;
    }

    public boolean didReachInSessionCappingLimit() {
        return this.mDisplayCount >= this.mInSessionCap - 1;
    }

    @NonNull
    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            if (this.mCls != null) {
                jSONObject.put("cls", (Object)this.mCls.a());
            }
            if (this.mTrigger != null) {
                jSONObject.put("trigger", this.mTrigger.a());
            }
            jSONObject.put("key", (Object)this.mPromotionEventsData.g());
            jSONObject.put("_id", this.mPromotionId);
            jSONObject.put("url", (Object)this.mUrl);
            jSONObject.put("priority", this.mPriority);
            jSONObject.put("cap", this.mCap);
            jSONObject.put("name", (Object)this.mName);
            jSONObject.put("enabled", this.mIsActive);
            jSONObject.put("promotion_revision_id", this.mPromotionRevisionId);
            jSONObject.put("direction", (Object)this.mDirection);
            jSONObject.put("revision_id", (Object)this.mRevisionId);
            if (this.mUiType != null) {
                jSONObject.put("ui_type", (Object)this.mUiType);
            }
            JSONArray jSONArray = new JSONArray();
            if (this.mActions != null) {
                for (int i2 = 0; i2 < this.mActions.size(); ++i2) {
                    JSONObject jSONObject2 = this.mActions.get(i2).a();
                    jSONArray.put(i2, (Object)jSONObject2);
                }
                jSONObject.put("actions", (Object)jSONArray);
            }
        }
        catch (Exception exception) {
            cf.a("" + exception.getMessage(), new Object[0]);
        }
        return jSONObject;
    }

    public void increaseDisplayCount() {
        ++this.mDisplayCount;
    }

    public boolean isWalkthrough() {
        return this.mCls == cs.a.b || this.mCls == cs.a.c;
    }

    public boolean isCampaignHasAutoSteps() {
        if (!this.isWalkthrough()) {
            return false;
        }
        da da2 = (da)this;
        for (cy cy2 : da2.h()) {
            if (!cy2.B()) continue;
            return true;
        }
        return false;
    }

    public boolean isCurrentStepWT() {
        try {
            cy cy2 = ((da)this).c();
            if (this.isWalkthrough() && cy2 != null && cy2.A()) {
                return true;
            }
        }
        catch (Exception exception) {
            cf.a("" + exception.getMessage(), new Object[0]);
        }
        return false;
    }

    public boolean isShoutout() {
        return this.mCls == cs.a.a;
    }

    public boolean isLauncher() {
        return this.mCls == cs.a.g;
    }

    public boolean isSWT() {
        return this.mCls == cs.a.c;
    }

    public boolean isNativeSurvey() {
        return this.mCls == cs.a.h;
    }

    public long getPromotionId() {
        return this.mPromotionId;
    }

    public void setPromotionId(long l2) {
        this.mPromotionId = l2;
    }

    @Nullable
    public cs.b getTrigger() {
        return this.mTrigger;
    }

    public ct getPromotionEventsData() {
        return this.mPromotionEventsData;
    }

    public long getPromotionRevisionId() {
        return this.mPromotionRevisionId;
    }

    @Nullable
    public String getUrl() {
        return this.mUrl;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public int getCap() {
        return this.mCap;
    }

    @Nullable
    public cs.a getCls() {
        return this.mCls;
    }

    public void setCls(cs.a a2) {
        this.mCls = a2;
    }

    @NonNull
    public List<cu> getActions() {
        return this.mActions;
    }

    @Nullable
    public String getName() {
        return this.mName;
    }

    public boolean isActive() {
        return this.mIsActive;
    }

    public int getDisplayCount() {
        return this.mDisplayCount;
    }

    public boolean wasImpressionSent() {
        return this.mWasImpressionSent;
    }

    public void setImpressionSent() {
        this.mWasImpressionSent = true;
    }

    public long getLastCtaId() {
        return this.mLastCtaId;
    }

    public void setLastCtaId(long l2) {
        this.mLastCtaId = l2;
    }

    @Nullable
    public String getLastCta() {
        return this.mLastCta;
    }

    public void setLastCta(String string) {
        this.mLastCta = string;
    }

    @Nullable
    public Boolean getIsRequestAccessibilityFocus() {
        return this.mIsRequestAccessibilityFocus;
    }

    public boolean shouldAnimate() {
        b b2 = null;
        if (this.isWalkthrough()) {
            da da2 = (da)this;
            cy cy2 = da2.c();
            if (cy2 != null) {
                b2 = cy2.G();
            }
            if (b2 == null) {
                b2 = da2.w();
            }
        } else if (this instanceof cy) {
            b2 = ((cy)this).G();
        }
        return b2 == null || b2.a() != -1;
    }

    public String getDirection() {
        return this.mDirection;
    }

    @NonNull
    public ArrayList<Long> getLabels() {
        return this.mLabels;
    }

    private void setLabels(@NonNull JSONObject jSONObject) {
        try {
            JSONArray jSONArray = jSONObject.optJSONArray("campaign_labels");
            if (jSONArray != null) {
                for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                    this.mLabels.add(jSONArray.getLong(i2));
                }
            }
        }
        catch (Exception exception) {
            cf.a("Failed to handle with promotion label " + exception.getMessage(), new Object[0]);
        }
    }

    @NonNull
    public String toString() {
        return "WMPromotionObject {mPromotionId=" + this.mPromotionId + ", mTrigger='" + (Object)((Object)this.mTrigger) + '\'' + ", mUrl=" + this.mUrl + '\'' + ", mPriority=" + this.mPriority + '\'' + ", mCap=" + this.mCap + '\'' + ", mName=" + this.mName + '}';
    }

    public String getCampaignRevisionId() {
        return this.mCampaignRevisionId;
    }
}

