/*
 * Decompiled with CFR 0.152.
 */
package abbi.io.abbisdk.model;

import abbi.io.abbisdk.b;
import abbi.io.abbisdk.ce;
import abbi.io.abbisdk.cq;
import abbi.io.abbisdk.cr;
import abbi.io.abbisdk.cs;
import abbi.io.abbisdk.ct;
import abbi.io.abbisdk.cx;
import abbi.io.abbisdk.cz;
import abbi.io.abbisdk.d;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WMPromotionObject {
    protected long mPromotionId;
    protected cr.b mTrigger;
    private String mUrl;
    private int mPriority;
    protected int mCap;
    private String mName;
    private String mUiType;
    private boolean mIsActive;
    protected cr.a mCls;
    private List<ct> mActions;
    private long mPromotionRevisionId;
    private int mInSessionCap = 1;
    private String mDirection;
    private String mRevisionId;
    private String mCampaignRevisionId;
    private cs mPromotionEventsData = new cs();
    private int mDisplayCount;
    private boolean mWasImpressionSent;
    private long mLastCtaId;
    private String mLastCta;
    private Boolean mIsRequestAccessibilityFocus;
    private ArrayList<Long> mLabels;

    public WMPromotionObject() {
    }

    public WMPromotionObject(JSONObject jSONObject) {
        this();
        JSONObject jSONObject2;
        JSONObject jSONObject3;
        this.mPromotionId = jSONObject.optLong("_id");
        this.mTrigger = this.parseTrigger(jSONObject.optInt("trigger"));
        this.mUrl = jSONObject.optString("url");
        this.mPriority = jSONObject.optInt("priority", 1);
        this.mCap = jSONObject.optInt("cap", 1);
        if (this.mCap == -1) {
            this.mCap = Integer.MAX_VALUE;
        }
        try {
            jSONObject3 = jSONObject.optJSONObject("frequency");
            if (jSONObject3 != null && (jSONObject2 = jSONObject3.optJSONObject("inSession")) != null && jSONObject2.optString("type").equals("impressions")) {
                this.mInSessionCap = jSONObject2.optInt("interval", 1);
                if (this.mInSessionCap == -1) {
                    this.mInSessionCap = Integer.MAX_VALUE;
                }
            }
        }
        catch (Exception exception) {
            ce.a("" + exception.getMessage(), new Object[0]);
        }
        this.mName = jSONObject.optString("name");
        this.mIsActive = jSONObject.optBoolean("enabled");
        this.mCls = WMPromotionObject.parseCls(jSONObject.optString("cls"));
        this.mPromotionEventsData.a(jSONObject.optString("key", ""));
        this.mCampaignRevisionId = jSONObject.optString("campaign_revision_id");
        this.mPromotionRevisionId = jSONObject.optLong("promotion_revision_id", 1L);
        this.mRevisionId = jSONObject.optString("revision_id", "-1");
        this.mUiType = jSONObject.optString("ui_type");
        this.mActions = new ArrayList<ct>();
        jSONObject3 = jSONObject.optJSONArray("actions");
        if (jSONObject3 != null) {
            for (int i2 = 0; i2 < jSONObject3.length(); ++i2) {
                try {
                    this.mActions.add(new ct(jSONObject3.getJSONObject(i2)));
                    continue;
                }
                catch (JSONException jSONException) {
                    ce.a("Can't add action object from JSON - " + jSONException.getMessage(), new Object[0]);
                }
            }
        }
        if (this.mName == null) {
            this.mName = jSONObject.optString("name");
        }
        if (this.mPromotionId == 0L) {
            this.mPromotionId = jSONObject.optLong("promotionID");
        }
        this.mIsRequestAccessibilityFocus = (jSONObject2 = jSONObject.optJSONObject("accessibility")) != null ? Boolean.valueOf(jSONObject2.optBoolean("requestAccessibilityFocus")) : null;
        this.mDirection = jSONObject.optString("direction", "ltr");
        this.mLabels = new ArrayList();
        this.setLabels(jSONObject);
    }

    public static WMPromotionObject promotionWithData(JSONObject jSONObject) {
        int n2 = jSONObject.optInt("version");
        cr.a a2 = WMPromotionObject.parseCls(jSONObject.optString("cls"));
        if (a2 != null) {
            switch (a2) {
                case a: 
                case f: 
                case h: {
                    return new cx(jSONObject, n2, 0L);
                }
                case g: {
                    return new cq(jSONObject, n2, 0L);
                }
                case b: 
                case c: {
                    return new cz(jSONObject, n2);
                }
            }
        }
        return null;
    }

    private cr.b parseTrigger(int n2) {
        switch (n2) {
            case -1: {
                this.mPromotionEventsData.a(cs.b.c);
                return cr.b.a;
            }
            case 0: {
                this.mPromotionEventsData.a(cs.b.f);
                return cr.b.b;
            }
            case 1: {
                this.mPromotionEventsData.a(cs.b.e);
                return cr.b.c;
            }
        }
        return null;
    }

    private static cr.a parseCls(String string) {
        switch (string) {
            case "PROMOTION_BUILDER": {
                return cr.a.a;
            }
            case "WALKTHROUGH": {
                return cr.a.b;
            }
            case "SWT": {
                return cr.a.c;
            }
            case "SWT_SPLIT": {
                return cr.a.d;
            }
            case "SWT_PENDING": {
                return cr.a.e;
            }
            case "SURVEY": {
                return cr.a.f;
            }
            case "NATIVE_SURVEY": {
                return cr.a.h;
            }
            case "LAUNCHER": {
                return cr.a.g;
            }
            case "WAIT_FOR": {
                return cr.a.i;
            }
            case "WM_DATA": {
                return cr.a.j;
            }
            case "SWT_CONNECTED": {
                return cr.a.k;
            }
        }
        return null;
    }

    public int getPromotionCount() {
        d d2 = d.a();
        return d2.d(this.mPromotionId);
    }

    public boolean didReachCappingLimit() {
        d d2 = d.a();
        int n2 = d2.d(this.mPromotionId);
        return n2 >= this.mCap;
    }

    public boolean didReachInSessionCappingLimit() {
        return this.mDisplayCount >= this.mInSessionCap - 1;
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("cls", (Object)this.mCls.a());
            jSONObject.put("trigger", (Object)Integer.toString(this.mTrigger.a()));
            jSONObject.put("key", (Object)this.mPromotionEventsData.g());
            jSONObject.put("_id", this.mPromotionId);
            jSONObject.put("url", (Object)this.mUrl);
            jSONObject.put("priority", this.mPriority);
            jSONObject.put("cap", this.mCap);
            jSONObject.put("name", (Object)this.mName);
            jSONObject.put("enabled", this.mIsActive);
            jSONObject.put("promotion_revision_id", this.mPromotionRevisionId);
            jSONObject.put("direction", (Object)this.mDirection);
            jSONObject.put("revision_id", (Object)this.mRevisionId);
            if (this.mUiType != null) {
                jSONObject.put("ui_type", (Object)this.mUiType);
            }
            JSONArray jSONArray = new JSONArray();
            if (this.mActions != null) {
                for (int i2 = 0; i2 < this.mActions.size(); ++i2) {
                    JSONObject jSONObject2 = this.mActions.get(i2).a();
                    jSONArray.put(i2, (Object)jSONObject2);
                }
                jSONObject.put("actions", (Object)jSONArray);
            }
        }
        catch (Exception exception) {
            ce.a(exception.getMessage(), new Object[0]);
        }
        return jSONObject;
    }

    public void increaseDisplayCount() {
        ++this.mDisplayCount;
    }

    public boolean isWalkthrough() {
        return this.mCls == cr.a.b || this.mCls == cr.a.c;
    }

    public boolean isCampaignHasAutoSteps() {
        if (!this.isWalkthrough()) {
            return false;
        }
        cz cz2 = (cz)this;
        for (cx cx2 : cz2.i()) {
            if (!cx2.B()) continue;
            return true;
        }
        return false;
    }

    public boolean isCurrentStepWT() {
        try {
            if (this.isWalkthrough() && ((cz)this).d().A()) {
                return true;
            }
        }
        catch (Exception exception) {
            ce.a(exception.getMessage(), new Object[0]);
        }
        return false;
    }

    public boolean isShoutout() {
        return this.mCls == cr.a.a;
    }

    public boolean isLauncher() {
        return this.mCls == cr.a.g;
    }

    public boolean isSWT() {
        return this.mCls == cr.a.c;
    }

    public boolean isNativeSurvey() {
        return this.mCls == cr.a.h;
    }

    public long getPromotionId() {
        return this.mPromotionId;
    }

    public void setPromotionId(long l2) {
        this.mPromotionId = l2;
    }

    public cr.b getTrigger() {
        return this.mTrigger;
    }

    public cs getPromotionEventsData() {
        return this.mPromotionEventsData;
    }

    public long getPromotionRevisionId() {
        return this.mPromotionRevisionId;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public int getCap() {
        return this.mCap;
    }

    public cr.a getCls() {
        return this.mCls;
    }

    public void setCls(cr.a a2) {
        this.mCls = a2;
    }

    public List<ct> getActions() {
        return this.mActions;
    }

    public String getName() {
        return this.mName;
    }

    public boolean isActive() {
        return this.mIsActive;
    }

    public int getDisplayCount() {
        return this.mDisplayCount;
    }

    public boolean wasImpressionSent() {
        return this.mWasImpressionSent;
    }

    public void setImpressionSent() {
        this.mWasImpressionSent = true;
    }

    public long getLastCtaId() {
        return this.mLastCtaId;
    }

    public void setLastCtaId(long l2) {
        this.mLastCtaId = l2;
    }

    public String getLastCta() {
        return this.mLastCta;
    }

    public void setLastCta(String string) {
        this.mLastCta = string;
    }

    public Boolean getIsRequestAccessibilityFocus() {
        return this.mIsRequestAccessibilityFocus;
    }

    public boolean shouldAnimate() {
        b b2 = null;
        if (this.isWalkthrough()) {
            cz cz2 = (cz)this;
            b2 = cz2.d().G();
            if (b2 == null) {
                b2 = cz2.x();
            }
        } else if (this instanceof cx) {
            b2 = ((cx)this).G();
        }
        return b2 == null || b2.a() != -1;
    }

    public String getDirection() {
        return this.mDirection;
    }

    public ArrayList<Long> getLabels() {
        return this.mLabels;
    }

    private void setLabels(JSONObject jSONObject) {
        try {
            JSONArray jSONArray = jSONObject.optJSONArray("campaign_labels");
            if (jSONArray != null) {
                for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                    this.mLabels.add(jSONArray.getLong(i2));
                }
            }
        }
        catch (Exception exception) {
            ce.a("Failed to handle with promotion label " + exception.getMessage(), new Object[0]);
        }
    }

    public String toString() {
        return "WMPromotionObject {mPromotionId=" + this.mPromotionId + ", mTrigger='" + (Object)((Object)this.mTrigger) + '\'' + ", mUrl=" + this.mUrl + '\'' + ", mPriority=" + this.mPriority + '\'' + ", mCap=" + this.mCap + '\'' + ", mName=" + this.mName + '}';
    }

    public String getCampaignRevisionId() {
        return this.mCampaignRevisionId;
    }
}

