/*
 * Decompiled with CFR 0.152.
 */
package abbi.io.abbisdk.model;

import abbi.io.abbisdk.b;
import abbi.io.abbisdk.cn;
import abbi.io.abbisdk.cz;
import abbi.io.abbisdk.d;
import abbi.io.abbisdk.da;
import abbi.io.abbisdk.db;
import abbi.io.abbisdk.dc;
import abbi.io.abbisdk.dg;
import abbi.io.abbisdk.di;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class WMPromotionObject {
    protected long mPromotionId;
    @Nullable
    protected da.b mTrigger;
    @Nullable
    private String mUrl;
    private int mPriority;
    protected int mCap;
    @Nullable
    private String mName;
    @Nullable
    private String mUiType;
    private boolean mIsActive;
    @Nullable
    protected da.a mCls;
    @NonNull
    private List<dc> mActions = new ArrayList<dc>();
    private long mPromotionRevisionId;
    private int mInSessionCap = 1;
    private String mDirection = "ltr";
    private String mRevisionId = "-1";
    private String mCampaignRevisionId = "";
    private db mPromotionEventsData;
    private int mDisplayCount;
    private boolean mWasImpressionSent;
    private long mLastCtaId;
    @Nullable
    private String mLastCta;
    @Nullable
    private Boolean mIsRequestAccessibilityFocus;
    @NonNull
    private ArrayList<Long> mLabels = new ArrayList();
    private JSONObject mFrequencyObject = new JSONObject();

    public WMPromotionObject() {
        this.mPromotionEventsData = new db();
    }

    public WMPromotionObject(@NonNull JSONObject jSONObject) {
        this();
        JSONObject jSONObject2;
        JSONObject jSONObject3;
        this.mPromotionId = jSONObject.optLong("_id");
        this.mTrigger = this.parseTrigger(jSONObject.optInt("trigger"));
        this.mUrl = jSONObject.optString("url");
        this.mPriority = jSONObject.optInt("priority", 1);
        this.mCap = jSONObject.optInt("cap", 1);
        if (this.mCap == -1) {
            this.mCap = Integer.MAX_VALUE;
        }
        try {
            this.mFrequencyObject = jSONObject.optJSONObject("frequency");
            if (this.mFrequencyObject != null && (jSONObject3 = this.mFrequencyObject.optJSONObject("inSession")) != null && jSONObject3.optString("type").equals("impressions")) {
                this.mInSessionCap = jSONObject3.optInt("interval", 1);
                if (this.mInSessionCap == -1) {
                    this.mInSessionCap = Integer.MAX_VALUE;
                }
            }
        }
        catch (Exception exception) {
            cn.a("" + exception.getMessage(), new Object[0]);
        }
        this.mName = jSONObject.optString("name");
        this.mIsActive = jSONObject.optBoolean("enabled");
        this.mCls = WMPromotionObject.parseCls(jSONObject.optString("cls"));
        this.mPromotionEventsData.a(jSONObject.optString("key", ""));
        this.mCampaignRevisionId = jSONObject.optString("campaign_revision_id");
        this.mPromotionRevisionId = jSONObject.optLong("promotion_revision_id", 1L);
        this.mRevisionId = jSONObject.optString("revision_id", "-1");
        this.mUiType = jSONObject.optString("ui_type");
        this.mActions = new ArrayList<dc>();
        jSONObject3 = jSONObject.optJSONArray("actions");
        if (jSONObject3 != null) {
            for (int i2 = 0; i2 < jSONObject3.length(); ++i2) {
                try {
                    this.mActions.add(new dc(jSONObject3.getJSONObject(i2)));
                    continue;
                }
                catch (Exception exception) {
                    cn.a("Can't add action object from JSON - " + exception.getMessage(), new Object[0]);
                }
            }
        }
        if (this.mName == null) {
            this.mName = jSONObject.optString("name");
        }
        if (this.mPromotionId == 0L) {
            this.mPromotionId = jSONObject.optLong("promotionID");
        }
        this.mIsRequestAccessibilityFocus = (jSONObject2 = jSONObject.optJSONObject("accessibility")) != null ? Boolean.valueOf(jSONObject2.optBoolean("requestAccessibilityFocus")) : null;
        this.mDirection = jSONObject.optString("direction", "ltr");
        this.setLabels(jSONObject);
    }

    @Nullable
    public static WMPromotionObject promotionWithData(@NonNull JSONObject jSONObject) {
        int n2 = jSONObject.optInt("version");
        da.a a2 = WMPromotionObject.parseCls(jSONObject.optString("cls"));
        if (a2 != null) {
            switch (a2) {
                case a: 
                case f: 
                case h: {
                    return new dg(jSONObject, n2, 0L);
                }
                case g: {
                    return new cz(jSONObject, n2, 0L);
                }
                case b: 
                case c: {
                    return new di(jSONObject, n2);
                }
            }
        }
        return null;
    }

    @Nullable
    private da.b parseTrigger(int n2) {
        switch (n2) {
            case -1: {
                this.mPromotionEventsData.a(db.b.c);
                return da.b.a;
            }
            case 1: {
                this.mPromotionEventsData.a(db.b.e);
                return da.b.b;
            }
        }
        return null;
    }

    @Nullable
    private static da.a parseCls(@NonNull String string) {
        switch (string) {
            case "PROMOTION_BUILDER": {
                return da.a.a;
            }
            case "WALKTHROUGH": {
                return da.a.b;
            }
            case "SWT": {
                return da.a.c;
            }
            case "SWT_SPLIT": {
                return da.a.d;
            }
            case "SWT_PENDING": {
                return da.a.e;
            }
            case "SURVEY": {
                return da.a.f;
            }
            case "NATIVE_SURVEY": {
                return da.a.h;
            }
            case "LAUNCHER": {
                return da.a.g;
            }
            case "WAIT_FOR": {
                return da.a.i;
            }
            case "WM_DATA": {
                return da.a.j;
            }
            case "SWT_CONNECTED": {
                return da.a.k;
            }
        }
        return null;
    }

    public int getPromotionCount() {
        d d2 = d.a();
        return d2 != null ? d2.d(this.mPromotionId) : 0;
    }

    public boolean didReachCappingLimit() {
        d d2 = d.a();
        int n2 = d2 != null ? d2.d(this.mPromotionId) : 0;
        return n2 >= this.mCap;
    }

    public boolean didReachInSessionCappingLimit() {
        return this.mDisplayCount >= this.mInSessionCap - 1;
    }

    @NonNull
    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            if (this.mCls != null) {
                jSONObject.put("cls", (Object)this.mCls.a());
            }
            if (this.mTrigger != null) {
                jSONObject.put("trigger", this.mTrigger.a());
            }
            jSONObject.put("key", (Object)this.mPromotionEventsData.g());
            jSONObject.put("_id", this.mPromotionId);
            jSONObject.put("url", (Object)this.mUrl);
            jSONObject.put("priority", this.mPriority);
            jSONObject.put("cap", this.mCap);
            jSONObject.put("name", (Object)this.mName);
            jSONObject.put("enabled", this.mIsActive);
            jSONObject.put("promotion_revision_id", this.mPromotionRevisionId);
            jSONObject.put("direction", (Object)this.mDirection);
            jSONObject.put("revision_id", (Object)this.mRevisionId);
            jSONObject.put("frequency", (Object)this.mFrequencyObject);
            if (this.mUiType != null) {
                jSONObject.put("ui_type", (Object)this.mUiType);
            }
            JSONArray jSONArray = new JSONArray();
            if (this.mActions != null) {
                for (int i2 = 0; i2 < this.mActions.size(); ++i2) {
                    JSONObject jSONObject2 = this.mActions.get(i2).a();
                    jSONArray.put(i2, (Object)jSONObject2);
                }
                jSONObject.put("actions", (Object)jSONArray);
            }
        }
        catch (Exception exception) {
            cn.a("" + exception.getMessage(), new Object[0]);
        }
        return jSONObject;
    }

    public void increaseDisplayCount() {
        ++this.mDisplayCount;
    }

    public boolean isWalkthrough() {
        return this.mCls == da.a.b || this.mCls == da.a.c;
    }

    public boolean isCampaignHasAutoSteps() {
        if (!this.isWalkthrough()) {
            return false;
        }
        di di2 = (di)this;
        for (dg dg2 : di2.f()) {
            if (!dg2.B()) continue;
            return true;
        }
        return false;
    }

    public boolean isCurrentStepWT() {
        try {
            dg dg2 = ((di)this).c();
            if (this.isWalkthrough() && dg2 != null && dg2.A()) {
                return true;
            }
        }
        catch (Exception exception) {
            cn.a("" + exception.getMessage(), new Object[0]);
        }
        return false;
    }

    public boolean isShoutout() {
        return this.mCls == da.a.a;
    }

    public boolean isLauncher() {
        return this.mCls == da.a.g;
    }

    public boolean isSWT() {
        return this.mCls == da.a.c;
    }

    public boolean isNativeSurvey() {
        return this.mCls == da.a.h;
    }

    public long getPromotionId() {
        return this.mPromotionId;
    }

    public void setPromotionId(long l2) {
        this.mPromotionId = l2;
    }

    @Nullable
    public da.b getTrigger() {
        return this.mTrigger;
    }

    public db getPromotionEventsData() {
        return this.mPromotionEventsData;
    }

    public long getPromotionRevisionId() {
        return this.mPromotionRevisionId;
    }

    @Nullable
    public String getUrl() {
        return this.mUrl;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public int getCap() {
        return this.mCap;
    }

    @Nullable
    public da.a getCls() {
        return this.mCls;
    }

    public void setCls(da.a a2) {
        this.mCls = a2;
    }

    @NonNull
    public List<dc> getActions() {
        return this.mActions;
    }

    @Nullable
    public String getName() {
        return this.mName;
    }

    public boolean isActive() {
        return this.mIsActive;
    }

    public int getDisplayCount() {
        return this.mDisplayCount;
    }

    public boolean wasImpressionSent() {
        return this.mWasImpressionSent;
    }

    public void setImpressionSent() {
        this.mWasImpressionSent = true;
    }

    public long getLastCtaId() {
        return this.mLastCtaId;
    }

    public void setLastCtaId(long l2) {
        this.mLastCtaId = l2;
    }

    @Nullable
    public String getLastCta() {
        return this.mLastCta;
    }

    public void setLastCta(String string) {
        this.mLastCta = string;
    }

    @Nullable
    public Boolean getIsRequestAccessibilityFocus() {
        return this.mIsRequestAccessibilityFocus;
    }

    public boolean shouldAnimate() {
        b b2 = null;
        if (this.isWalkthrough()) {
            di di2 = (di)this;
            dg dg2 = di2.c();
            if (dg2 != null) {
                b2 = dg2.G();
            }
            if (b2 == null) {
                b2 = di2.o();
            }
        } else if (this instanceof dg) {
            b2 = ((dg)this).G();
        }
        return b2 == null || b2.a() != -1;
    }

    public String getDirection() {
        return this.mDirection;
    }

    @NonNull
    public ArrayList<Long> getLabels() {
        return this.mLabels;
    }

    private void setLabels(@NonNull JSONObject jSONObject) {
        try {
            JSONArray jSONArray = jSONObject.optJSONArray("campaign_labels");
            if (jSONArray != null) {
                for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                    this.mLabels.add(jSONArray.getLong(i2));
                }
            }
        }
        catch (Exception exception) {
            cn.a("Failed to handle with promotion label " + exception.getMessage(), new Object[0]);
        }
    }

    @NonNull
    public String toString() {
        return "WMPromotionObject {mPromotionId=" + this.mPromotionId + ", mTrigger='" + (Object)((Object)this.mTrigger) + '\'' + ", mUrl=" + this.mUrl + '\'' + ", mPriority=" + this.mPriority + '\'' + ", mCap=" + this.mCap + '\'' + ", mName=" + this.mName + '}';
    }

    public String getCampaignRevisionId() {
        return this.mCampaignRevisionId;
    }
}

