/*
 * Decompiled with CFR 0.152.
 */
package com.trung.fcm.library;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;

public class PrefsHelper {
    public static final String FCM_TOKEN = "fcm_token";
    public static final String SENT_TOKEN_TO_SERVER = "sentTokenToServer";
    public static final String REGISTRATION_COMPLETE = "registrationComplete";

    private PrefsHelper() {
    }

    public static void saveFCMToken(Context context, String fcmToken) {
        SharedPreferences pref = PreferenceManager.getDefaultSharedPreferences((Context)context.getApplicationContext());
        pref.edit().putString(FCM_TOKEN, fcmToken).apply();
    }

    public static String getFCMToken(Context context) {
        SharedPreferences pref = PreferenceManager.getDefaultSharedPreferences((Context)context.getApplicationContext());
        return pref.getString(FCM_TOKEN, "");
    }

    public static void sendFCMTokenToServer(Context context, boolean sent) {
        SharedPreferences pref = PreferenceManager.getDefaultSharedPreferences((Context)context.getApplicationContext());
        pref.edit().putBoolean(SENT_TOKEN_TO_SERVER, sent).apply();
    }

    public static boolean hasFCMToken(Context context) {
        SharedPreferences pref = PreferenceManager.getDefaultSharedPreferences((Context)context.getApplicationContext());
        return pref.getBoolean(SENT_TOKEN_TO_SERVER, false);
    }
}

