/*
 * Decompiled with CFR 0.152.
 */
package com.trung.fcm.library;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.v4.content.LocalBroadcastManager;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.RemoteMessage;
import com.trung.fcm.library.FCMListener;
import com.trung.fcm.library.PrefsHelper;
import com.trung.fcm.library.SaveFCMIdService;

public class FCMManager {
    private static FCMManager instance = null;
    private Context mContext;
    private FCMListener mFCMListener;
    private BroadcastReceiver mMessageReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (PrefsHelper.hasFCMToken(context) && FCMManager.this.mFCMListener != null) {
                FCMManager.this.mFCMListener.onDeviceRegistered(PrefsHelper.getFCMToken(context));
            }
        }
    };

    private FCMManager(Context mContext) {
        this.mContext = mContext;
        this.init();
    }

    public static FCMManager getInstance(Context context) {
        if (instance == null) {
            instance = new FCMManager(context);
        }
        return instance;
    }

    public void registerListener(FCMListener fcmListener) {
        this.mFCMListener = fcmListener;
    }

    public void unRegisterListener() {
        this.mFCMListener = null;
    }

    public void init() {
        LocalBroadcastManager.getInstance((Context)this.mContext).registerReceiver(this.mMessageReceiver, new IntentFilter("registrationComplete"));
        GoogleApiAvailability api = GoogleApiAvailability.getInstance();
        int status = api.isGooglePlayServicesAvailable(this.mContext);
        if (status == 0) {
            this.mContext.startService(new Intent(this.mContext, SaveFCMIdService.class));
        } else if (this.mFCMListener != null) {
            this.mFCMListener.onPlayServiceError();
        }
    }

    public void onMessage(RemoteMessage remoteMessage) {
        if (this.mFCMListener != null) {
            this.mFCMListener.onMessage(remoteMessage);
        }
    }

    public void subscribeTopic(String topicName) {
        if (PrefsHelper.hasFCMToken(this.mContext)) {
            FirebaseMessaging.getInstance().subscribeToTopic(topicName);
        }
    }

    public void unSubscribeTopic(String topicName) {
        if (PrefsHelper.hasFCMToken(this.mContext)) {
            FirebaseMessaging.getInstance().unsubscribeFromTopic(topicName);
        }
    }
}

